/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ccob.thin;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.lsst.ccs.drivers.ascii.Ascii;
import org.lsst.ccs.drivers.commons.DriverConstants;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.subsystem.ccob.thin.AsciiAuto;
import org.lsst.ccs.utilities.logging.Logger;

public class MockThin
extends AsciiAuto {
    private final List<String> replyQueue = new LinkedList<String>();
    private static final Logger LOG = Logger.getLogger((String)MockThin.class.getName());
    private static final Pattern COMMAND_PREFIX = Pattern.compile("[XYUBP]\\+?=");

    public void setTimeout(int time) throws DriverException {
    }

    public void setTimeout(double time) throws DriverException {
    }

    public void setTerminator(Ascii.Terminator term) {
    }

    public void setCommandTerm(Ascii.Terminator term) {
    }

    public void setResponseTerm(Ascii.Terminator term) {
    }

    public void flush() throws DriverException {
    }

    public int readBytes(byte[] buff, int offset, int leng) throws DriverException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public int readBytes(byte[] buff, int offset) throws DriverException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void writeBytes(byte[] command, int offset, int leng) throws DriverException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void writeBytes(byte[] command) throws DriverException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public String read(String command) throws DriverException {
        this.write(command);
        return this.read();
    }

    public String read() throws DriverException {
        try {
            return this.replyQueue.remove(0);
        }
        catch (IndexOutOfBoundsException exc) {
            throw new DriverException("The response is missing or incomplete, e.g., unterminated.", (Throwable)exc);
        }
    }

    public void write(String command) throws DriverException {
        boolean alwaysFail = false;
        LOG.info((Object)command);
        if (this.isMotionCommand(command)) {
            try {
                TimeUnit.SECONDS.sleep(3L);
            }
            catch (InterruptedException exc) {
                LOG.info((Object)"Command execution was interrupted!");
                Thread.currentThread().interrupt();
            }
        }
        if (command.startsWith("KC?")) {
            this.replyQueue.add("15.0");
        } else {
            this.replyQueue.add("X=1.5e-1mm, Y=0.0mm, U=0.0deg, B=0.0deg, P=0.0deg, Range: 42.0A (blah blah), K=3.14A");
        }
        this.replyQueue.add("");
    }

    public boolean closeSilent() {
        return true;
    }

    @Override
    public void close() throws DriverException {
    }

    public void openFtdi(String serialNo, int baudRate) throws DriverException {
    }

    public void openFtdi(String serialNo, int baudRate, int dataChar) throws DriverException {
    }

    public void openSerial(String devcName, int baudRate) throws DriverException {
    }

    public void openSerial(String devcName, int baudRate, int dataChar) throws DriverException {
    }

    public void openNet(String host, int port) throws DriverException {
    }

    public void open(DriverConstants.ConnType type, String ident, int parm) throws DriverException {
    }

    public void open(DriverConstants.ConnType type, String ident, int parm1, int parm2) throws DriverException {
    }

    private boolean isMotionCommand(String command) {
        return COMMAND_PREFIX.matcher(command).lookingAt();
    }
}

