/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.motorplatform.main;

import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.services.AgentPropertiesService;
import org.lsst.ccs.subsystem.motorplatform.bus.ChangeAxisEnable;
import org.lsst.ccs.subsystem.motorplatform.bus.ChangeOutputLine;
import org.lsst.ccs.subsystem.motorplatform.bus.ClearAllFaults;
import org.lsst.ccs.subsystem.motorplatform.bus.ClearAxisFaults;
import org.lsst.ccs.subsystem.motorplatform.bus.ClearCapture;
import org.lsst.ccs.subsystem.motorplatform.bus.EnableAllAxes;
import org.lsst.ccs.subsystem.motorplatform.bus.HomeAxis;
import org.lsst.ccs.subsystem.motorplatform.bus.MotorCommandListener;
import org.lsst.ccs.subsystem.motorplatform.bus.MotorplatformType;
import org.lsst.ccs.subsystem.motorplatform.bus.MoveAxisAbsolute;
import org.lsst.ccs.subsystem.motorplatform.bus.MoveAxisRelative;
import org.lsst.ccs.subsystem.motorplatform.bus.SendAxisStatus;
import org.lsst.ccs.subsystem.motorplatform.bus.SendConfiguration;
import org.lsst.ccs.subsystem.motorplatform.bus.SendControllerStatus;
import org.lsst.ccs.subsystem.motorplatform.bus.SetupCapture;
import org.lsst.ccs.subsystem.motorplatform.bus.StopAllMotion;
import org.lsst.ccs.subsystem.motorplatform.main.DummyController;

public class DummyPlatform
extends Subsystem
implements MotorCommandListener,
HasLifecycle {
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private volatile DummyController controller;

    public DummyPlatform() {
        super("dummy", AgentInfo.AgentType.WORKER);
    }

    public void postInit() {
        ((AgentPropertiesService)this.getAgentService(AgentPropertiesService.class)).setAgentProperty("motorplatform.type", MotorplatformType.BOT.name());
    }

    @Command(description="Enable or disable an axis.")
    public void changeAxisEnable(ChangeAxisEnable cmd) {
        this.controller.changeAxisEnable(cmd);
    }

    @Command(description="Change the state of one of the user-defined output lines.")
    public void changeOutputLine(ChangeOutputLine cmd) {
        this.controller.changeOutputLine(cmd);
    }

    @Command(description="Clear all fault conditions on all axes.")
    public void clearAllFaults(ClearAllFaults cmd) {
        this.controller.clearAllFaults(cmd);
    }

    @Command(description="Clear all fault conditions on a given axis.")
    public void clearAxisFaults(ClearAxisFaults cmd) {
        this.controller.clearAxisFaults(cmd);
    }

    @Command(description="Turn off data capture during motion.")
    public void clearCapture(ClearCapture cmd) {
        this.controller.clearCapture(cmd);
    }

    @Command(description="Enable all axes for motion.")
    public void enableAllAxes(EnableAllAxes cmd) {
        this.controller.enableAllAxes(cmd);
    }

    @Command(description="Perform a single relative motion on a given axis.")
    public void moveAxisRelative(MoveAxisRelative cmd) {
        this.controller.moveAxisRelative(cmd);
    }

    @Command(description="Perform a single motion on a given axis to an absolute position.")
    public void moveAxisAbsolute(MoveAxisAbsolute cmd) {
        this.controller.moveAxisAbsolute(cmd);
    }

    @Command(description="Start a homing operation on the given axis.")
    public void homeAxis(HomeAxis cmd) {
        this.controller.homeAxis(cmd);
    }

    @Command(description="Report on the status of a given axis.")
    public void sendAxisStatus(SendAxisStatus cmd) {
        this.controller.sendAxisStatus(cmd);
    }

    @Command(description="Send the platform configuration on the status bus.")
    public void sendConfiguration(SendConfiguration cmd) {
        this.controller.sendConfiguration(cmd);
    }

    @Command(description="Report on the status of the motor controller.")
    public void sendControllerStatus(SendControllerStatus cmd) {
        this.controller.sendControllerStatus(cmd);
    }

    @Command(description="Arrange for a given variable to be captured at intervals during motion.")
    public void setupCapture(SetupCapture cmd) {
        this.controller.setupCapture(cmd);
    }

    @Command(description="Stop all motion on all axes.")
    public void stopAllMotion(StopAllMotion cmd) {
        this.controller.stopAllMotion(cmd);
    }
}

