/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.newportlamp;

import java.text.DecimalFormat;
import org.lsst.ccs.drivers.ascii.Ascii;
import org.lsst.ccs.drivers.commons.DriverConstants;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.commons.DriverTimeoutException;

public class NewportLamp
extends Ascii {
    private final int numberOfReadAttempts = 20;
    private final double minCurrent = 3.0;
    private final double maxCurrent = 24.0;
    private final int minPower = 40;
    private final int maxPower = 300;

    public NewportLamp() {
        this.setOptions(Ascii.Option.NO_NET);
    }

    public void open(DriverConstants.ConnType connType, String devcName, int baudRate, int dataChar) throws DriverException {
        super.open(connType, devcName, baudRate, 0);
        this.init();
    }

    public void init() {
        this.setCommandTerm(Ascii.Terminator.CR);
    }

    public boolean getState() throws DriverException {
        return this.statusLampOn();
    }

    public void setState(boolean on) throws DriverException {
        this.readNewportLamp(on ? "START" : "STOP");
    }

    public void reset() throws DriverException {
        this.readNewportLamp("RST");
    }

    public String getStatus() throws DriverException {
        return this.readNewportLamp("STB?");
    }

    public int stripStatus(String status) throws DriverException {
        int stripped_val = 0;
        try {
            stripped_val = status.contains("STB") ? Integer.parseInt(status.substring(3), 16) : Integer.parseInt(status, 16);
        }
        catch (NumberFormatException ex) {
            System.out.println("Failed to make an int out of status stripped string(" + status + ") : " + ex);
        }
        return stripped_val;
    }

    public boolean statusLampOn() throws DriverException {
        return (this.stripStatus(this.getStatus()) & 0x80) != 0;
    }

    public boolean statusExt() throws DriverException {
        return (this.stripStatus(this.getStatus()) & 0x40) != 0;
    }

    public boolean statusPowerMode() throws DriverException {
        return (this.stripStatus(this.getStatus()) & 0x20) != 0;
    }

    public boolean statusCurrentMode() throws DriverException {
        return (this.stripStatus(this.getStatus()) & 0x20) != 1;
    }

    public boolean statusCalMode() throws DriverException {
        return (this.stripStatus(this.getStatus()) & 0x10) != 0;
    }

    public boolean statusFault() throws DriverException {
        return (this.stripStatus(this.getStatus()) & 8) != 0;
    }

    public boolean statusComm() throws DriverException {
        return (this.stripStatus(this.getStatus()) & 4) != 0;
    }

    public boolean statusLimit() throws DriverException {
        return (this.stripStatus(this.getStatus()) & 2) != 0;
    }

    public boolean statusInterlock() throws DriverException {
        return (this.stripStatus(this.getStatus()) & 1) != 0;
    }

    public int stripError(String err) throws DriverException {
        if (err.contains("ESR")) {
            return Integer.parseInt(err.substring(3), 16);
        }
        return Integer.parseInt(err, 16);
    }

    public String getError() throws DriverException {
        return this.readNewportLamp("ESR?");
    }

    public boolean errorCommand() throws DriverException {
        return this.parseErrorCommand(this.getError());
    }

    public boolean errorOpComplete() throws DriverException {
        return this.parseErrorOpComplete(this.getError());
    }

    public boolean parseErrorCommand(String err) throws DriverException {
        return (this.stripError(err) & 0x20) != 0;
    }

    public boolean parseErrorOpComplete(String err) throws DriverException {
        return (this.stripError(err) & 1) != 0;
    }

    public String getIdent() throws DriverException {
        return this.readNewportLamp("IDN?");
    }

    public double getAmps() throws DriverException {
        return Double.valueOf(this.readNewportLamp("AMPS?"));
    }

    public void setMode(int mode) throws DriverException {
        if (mode != 0 && mode != 1) {
            throw new IllegalArgumentException("mode is not 0 or 1");
        }
        String command = "MODE=" + Integer.toString(mode);
        String status = this.readNewportLamp(command);
    }

    public double getVolts() throws DriverException {
        return Double.valueOf(this.readNewportLamp("VOLTS?"));
    }

    public double getWatts() throws DriverException {
        return Double.valueOf(this.readNewportLamp("WATTS?"));
    }

    public double getCurrentPreset() throws DriverException {
        return Double.valueOf(this.readNewportLamp("A-PRESET?"));
    }

    public void setCurrentPreset(double a) throws DriverException {
        if (a < 3.0 || a > 24.0) {
            throw new IllegalArgumentException("requested value is above current Limit");
        }
        if (a > this.getCurrentLim() || a < 0.0) {
            throw new IllegalArgumentException("requested value is above current Limit");
        }
        DecimalFormat df = new DecimalFormat("##.##");
        String command = "A-PRESET=" + df.format(a);
        String err = this.readNewportLamp(command);
        if (this.parseErrorCommand(err)) {
            throw new DriverException("Command Error");
        }
    }

    public double getCurrentLim() throws DriverException {
        return Double.valueOf(this.readNewportLamp("A-LIM?"));
    }

    public void setCurrentLim(double a) throws DriverException {
        if (a < 3.0 || a > 24.0) {
            throw new IllegalArgumentException("requested value is above current Limit");
        }
        DecimalFormat df = new DecimalFormat("##.##");
        String command = "A-LIM=" + df.format(a);
        String err = this.readNewportLamp(command);
        if (this.parseErrorCommand(err)) {
            throw new DriverException("Command Error");
        }
    }

    public int getPowerPreset() throws DriverException {
        return Integer.valueOf(this.readNewportLamp("P-PRESET?"));
    }

    public void setPowerPreset(int p) throws DriverException {
        if (p < 40 || p > 300) {
            throw new IllegalArgumentException("power setting out of manufacturer's bounds");
        }
        if (p < 0 || p > this.getPowerLim()) {
            throw new IllegalArgumentException("power setting invalid");
        }
        String command = "P-PRESET=" + Integer.toString(p);
        String err = this.readNewportLamp(command);
        System.out.println("Setting power preset: " + err);
        if (this.parseErrorCommand(err)) {
            throw new DriverException("Command Error");
        }
    }

    public int getPowerLim() throws DriverException {
        return Integer.valueOf(this.readNewportLamp("P-LIM?"));
    }

    public void setPowerLim(int p) throws DriverException {
        if (p < 40 || p > 300) {
            throw new IllegalArgumentException("power setting out of manufacturer's bounds");
        }
        if (p < 0 || p > 9999) {
            throw new IllegalArgumentException("power setting invalid must be [0,9999]");
        }
        String command = "P-LIM=" + Integer.toString(p);
        String err = this.readNewportLamp(command);
        if (this.parseErrorCommand(err)) {
            throw new DriverException("Command Error");
        }
    }

    public synchronized String readNewportLamp(String command) throws DriverException {
        this.write(command);
        for (int i = 0; i < 20; ++i) {
            String result = "";
            try {
                result = this.read();
            }
            catch (DriverTimeoutException driverTimeoutException) {
                // empty catch block
            }
            if ("".equals(result)) continue;
            return result;
        }
        throw new DriverException("Could not get a valid response for command: " + command);
    }

    public static enum onOff {
        OFF,
        ON;

    }
}

