/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.readout;

import org.lsst.ccs.utilities.ccd.CCDType;
import org.lsst.ccs.utilities.readout.ReadOutParameters;
import org.lsst.ccs.utilities.readout.ReadOutParametersNew;
import org.lsst.ccs.utilities.readout.ReadOutParametersOld;
import org.lsst.ccs.utilities.readout.ReadOutRegisterMap;

public class ReadOutParametersBuilder {
    private int[] registers;
    private CCDType ccdType;
    private ReadOutRegisterMap registerMap;

    private ReadOutParametersBuilder() {
    }

    public static ReadOutParametersBuilder create() {
        return new ReadOutParametersBuilder();
    }

    public ReadOutParametersBuilder readoutParameterNames(String[] readoutParameterNames) {
        this.registerMap = new ReadOutRegisterMap(readoutParameterNames);
        return this;
    }

    public ReadOutParametersBuilder readoutParameterValues(int[] registers) {
        this.registers = registers;
        return this;
    }

    public ReadOutParametersBuilder ccdType(CCDType ccdType) {
        this.ccdType = ccdType;
        return this;
    }

    public ReadOutParameters build() {
        ReadOutParameters readoutParameters;
        if (this.registers == null && this.registerMap == null) {
            readoutParameters = new ReadOutParametersOld(this.ccdType);
        } else {
            if (this.ccdType == null) {
                return new ReadOutParametersNew(this.registers, this.registerMap);
            }
            if (this.registers == null || this.registerMap == null || this.registers.length != this.registerMap.size()) {
                throw new RuntimeException("Inconsistent registers and registerMap");
            }
            readoutParameters = this.registerMap.contains("OpFlags") ? new ReadOutParametersNew(this.registers, this.registerMap) : new ReadOutParametersOld(this.ccdType, this.registers, this.registerMap);
        }
        ((ReadOutParameters)readoutParameters).validate();
        return readoutParameters;
    }
}

