/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.camera.kafka.avro;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.avro.Schema;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.DataProviderDictionary;
import org.lsst.ccs.bus.data.DataProviderInfo;
import org.lsst.ccs.camera.Camera;
import org.lsst.ccs.camera.kafka.avro.AvroSchemaUtils;
import org.lsst.ccs.camera.kafka.avro.Topic;
import org.lsst.ccs.camera.kafka.avro.TopicWithTags;
import org.lsst.ccs.camera.sal.classes.DataProviderInfoUtils;
import org.lsst.ccs.camera.sal.xml.MakeXMLConfiguration;
import org.lsst.ccs.camera.sal.xml.Mapping;
import org.lsst.ccs.camera.sal.xml.TypeConverter;
import org.lsst.ccs.camera.sal.xml.XMLMaker2;

public class AvroSchemaMapper {
    private static final Logger LOG = Logger.getLogger(AvroSchemaMapper.class.getName());
    private static final List<String> config_limits = new ArrayList<String>();
    private final Camera c;
    private final TypeConverter typeConverter = new TypeConverter();
    private final Mapping map = Mapping.getMapping("avro.map");
    private final Map<String, Topic> topicsByNameMap = new LinkedHashMap<String, Topic>();
    private final Map<String, Topic.TopicField> topicFieldsByPath = new LinkedHashMap<String, Topic.TopicField>();
    private final Map<String, TopicWithTags> topicWithTagsByPath = new LinkedHashMap<String, TopicWithTags>();
    private final Map<String, Map<String, String>> tagValuesByPath = new LinkedHashMap<String, Map<String, String>>();
    private final Map<Topic, Schema> topicSchemaMap = new LinkedHashMap<Topic, Schema>();
    private final Set<String> availablePaths = new LinkedHashSet<String>();
    private final MakeXMLConfiguration xmlConfig;

    public AvroSchemaMapper(Camera c) {
        this.c = c;
        this.xmlConfig = MakeXMLConfiguration.getInstance(c, XMLMaker2.SALType.TELEMETRY);
    }

    void buildSchemasForLocalDictionaries() {
        try {
            this.buildAvroSchemas();
        }
        catch (IOException | ClassNotFoundException ex) {
            throw new RuntimeException("Could not build the avro schemas.", ex);
        }
        this.verifySchemas();
    }

    public Map<String, Topic> getAllTopicsMap() {
        return new LinkedHashMap<String, Topic>(this.topicsByNameMap);
    }

    public Topic.TopicField getTopicFieldForPath(String path) {
        return this.topicFieldsByPath.get(path);
    }

    public TopicWithTags getTopicWithTagsForPath(String path) {
        return this.topicWithTagsByPath.get(path);
    }

    public Schema getSchemaForTopic(Topic topic) {
        return this.topicSchemaMap.get(topic);
    }

    public Map<String, String> getTagValuesForPath(String path) {
        return this.tagValuesByPath.get(path);
    }

    Set<String> getAvailablePaths() {
        return new LinkedHashSet<String>(this.availablePaths);
    }

    public boolean addSchemaForDictionaryAndAgent(DataProviderDictionary dict, AgentInfo agentInfo) {
        if (this.xmlConfig.getDictionaryConfigurationForAgentInfo(agentInfo) != null) {
            this.buildAvroSchemaForDictionary(dict, agentInfo.getName());
            this.verifySchemas();
            return true;
        }
        return false;
    }

    public void removeSchemaForAgent(String agentName) {
    }

    private void buildAvroSchemas() throws ClassNotFoundException, IOException {
        for (MakeXMLConfiguration.DictionaryConfiguration dictConfig : this.xmlConfig.getOrderedListOfDictionaryConfigurations()) {
            this.buildAvroSchemaForDictionary(dictConfig.getDictionary(), dictConfig.getAgentName());
        }
    }

    private void buildAvroSchemaForDictionary(DataProviderDictionary dict, String agentName) {
        for (DataProviderInfo info : dict.getDataProviderInfos()) {
            Mapping.Match match;
            String dataType = info.getAttributeValue(DataProviderInfo.Attribute.DATA_TYPE);
            String doNotTrend = info.getAttributeValue(DataProviderInfo.Attribute.DO_NOT_TREND);
            if (doNotTrend != null && doNotTrend.equals("true") || !dataType.equals("TRENDING") && !dataType.equals("MONITORING")) continue;
            String path = info.getFullPath();
            String pathWithAgent = agentName + "/" + path;
            if (!DataProviderInfoUtils.acceptDataProviderInfo(info)) continue;
            String description = "";
            String attributeDescription = info.getAttributeValue(DataProviderInfo.Attribute.DESCRIPTION);
            if (attributeDescription != null) {
                description = attributeDescription.replace("\"", "").replace("\\", " ");
            }
            String units = info.getAttributeValue(DataProviderInfo.Attribute.UNITS);
            String field_type = info.getAttributeValue(DataProviderInfo.Attribute.TYPE);
            boolean hasState = false;
            if (dataType.equals("MONITORING")) {
                for (String key : config_limits) {
                    if (dict.getDataProviderInfoForPath(path + key) == null) continue;
                    hasState = true;
                    break;
                }
            }
            if ((match = this.map.match(path)) != null) {
                String namespace = "lsst." + this.c.getCscName();
                String topicName = namespace + "." + match.getPatternName();
                Topic topic = this.topicsByNameMap.computeIfAbsent(agentName + "." + topicName, t -> new Topic(topicName.replace(namespace + ".", ""), namespace));
                LinkedHashMap<String, String> tagsForPath = new LinkedHashMap<String, String>();
                for (String tag : match.getTagNames()) {
                    tagsForPath.put(tag, match.getTagValue(tag));
                    topic.addTag(tag, match.getTagValue(tag));
                }
                tagsForPath.put("Agent", agentName);
                topic.addTags(tagsForPath);
                this.topicFieldsByPath.put(pathWithAgent, topic.addField(match.getPathAfterMatch(), this.typeConverter.influxDbType(field_type), description, units));
                TopicWithTags topicWithTags = new TopicWithTags(topic, tagsForPath);
                this.topicWithTagsByPath.put(pathWithAgent, topicWithTags);
                this.tagValuesByPath.put(pathWithAgent, tagsForPath);
                this.availablePaths.add(pathWithAgent);
                if (hasState) {
                    String statePath = pathWithAgent + "/state";
                    this.topicFieldsByPath.put(statePath, topic.addField(match.getPathAfterMatch() + "_state", "string", "Monitoring state for " + path, "unitless"));
                    this.topicWithTagsByPath.put(statePath, topicWithTags);
                    this.tagValuesByPath.put(statePath, tagsForPath);
                    this.availablePaths.add(statePath);
                }
                topic.addTag("Agent", agentName);
                continue;
            }
            LOG.log(Level.WARNING, "The following path was not matched to an avro schema: {0} for subsystem {1}. The avro.map file needs to be updated accordingly.", new Object[]{path, agentName});
        }
        for (Topic t2 : this.topicsByNameMap.values()) {
            try {
                this.topicSchemaMap.put(t2, AvroSchemaUtils.generateSchemaForTopic(t2));
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to build topic " + t2.getFullName(), e);
            }
        }
    }

    private void verifySchemas() {
        HashSet<String> tags = new HashSet<String>();
        for (Topic t : this.topicsByNameMap.values()) {
            for (String tag : t.getTags()) {
                tags.add(tag);
            }
        }
        for (Topic t : this.topicsByNameMap.values()) {
            for (Topic.TopicField f : t.getFields()) {
                if (!tags.contains(f.getName())) continue;
                throw new RuntimeException("Field name is also a tag: " + f.getName());
            }
        }
    }

    static {
        config_limits.add("/limitLo");
        config_limits.add("/limitHi");
        config_limits.add("/warnLo");
        config_limits.add("/warnHi");
    }
}

