/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shutter.statemachine;

import java.time.Duration;
import java.util.logging.Logger;
import org.lsst.ccs.subsystem.shutter.common.PhysicalState;
import org.lsst.ccs.subsystem.shutter.common.ShutterSide;
import org.lsst.ccs.subsystem.shutter.common.SoftwareState;
import org.lsst.ccs.subsystem.shutter.plc.OpenShutter;
import org.lsst.ccs.subsystem.shutter.plc.TakeExposure;
import org.lsst.ccs.subsystem.shutter.statemachine.Actions;
import org.lsst.ccs.subsystem.shutter.statemachine.Channel;
import org.lsst.ccs.subsystem.shutter.statemachine.EventReply;
import org.lsst.ccs.subsystem.shutter.statemachine.Logging;
import org.lsst.ccs.subsystem.shutter.statemachine.Prod;
import org.lsst.ccs.subsystem.shutter.statemachine.PromptReply;
import org.lsst.ccs.subsystem.shutter.statemachine.SimpleState;

class Closed
extends SimpleState<Prod> {
    private static final Logger LOG = Logger.getLogger(Closed.class.getName());

    public Closed(Prod context) {
        super(context);
    }

    @Override
    public Logger getLogger() {
        return LOG;
    }

    @Override
    public void entry() {
        Logging.logEntry(this);
        ((Prod)this.getContext()).getActions().setSoftwareState(SoftwareState.CLOSED);
        ((Prod)this.getContext()).getActions().setPhysicalState(PhysicalState.CLOSED);
    }

    @Override
    public void openShutter(Channel<EventReply> chan) throws InterruptedException {
        Logging.logEvent(this);
        Actions act = ((Prod)this.getContext()).getActions();
        if (act.brakeIsEngaged(ShutterSide.MINUSX) || act.brakeIsEngaged(ShutterSide.MINUSX)) {
            chan.write(new PromptReply("At least one brake is engaged."));
        } else {
            chan.write(PromptReply.ACCEPTED);
            ((Prod)this.getContext()).makeTransition(((Prod)this.getContext()).getOpeningState(), () -> ((Prod)this.getContext()).getActions().relay(new OpenShutter()));
        }
    }

    @Override
    public void takeExposure(Channel<EventReply> chan, Duration exposureTime) throws InterruptedException {
        Logging.logEvent(this);
        Actions act = ((Prod)this.getContext()).getActions();
        if (exposureTime == null) {
            chan.write(new PromptReply("The exposure Duration musn't be null."));
        } else if (act.isBadExposureTime(exposureTime)) {
            chan.write(new PromptReply("The exposure time " + exposureTime + " is invalid."));
        } else if (act.brakeIsEngaged(ShutterSide.MINUSX) || act.brakeIsEngaged(ShutterSide.MINUSX)) {
            chan.write(new PromptReply("At least one brake is engaged."));
        } else {
            chan.write(PromptReply.ACCEPTED);
            ((Prod)this.getContext()).makeTransition(((Prod)this.getContext()).getOpeningState(), () -> ((Prod)this.getContext()).getActions().relay(new TakeExposure(exposureTime)));
        }
    }
}

