/*
 * Decompiled with CFR 0.152.
 */
package org.indilib.i4j.client;

import org.indilib.i4j.Constants;
import org.indilib.i4j.INDIException;
import org.indilib.i4j.client.INDIElement;
import org.indilib.i4j.client.INDIElementListener;
import org.indilib.i4j.client.INDILightProperty;
import org.indilib.i4j.client.INDIValueException;
import org.indilib.i4j.client.INDIViewCreator;
import org.indilib.i4j.protocol.DefElement;
import org.indilib.i4j.protocol.DefLight;
import org.indilib.i4j.protocol.OneElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class INDILightElement
extends INDIElement {
    private static final Logger LOG = LoggerFactory.getLogger(INDILightElement.class);
    private Constants.LightStates state;
    private INDIElementListener uiComponent;

    protected INDILightElement(DefLight xml, INDILightProperty property) {
        super((DefElement<?>)xml, property);
        this.setValue(xml.getTextContent());
    }

    public Constants.LightStates getValue() {
        return this.state;
    }

    @Override
    protected void setValue(OneElement<?> xml) {
        this.setValue(xml.getTextContent());
        this.notifyListeners();
    }

    private void setValue(String newState) {
        if (newState.compareTo("Idle") == 0) {
            this.state = Constants.LightStates.IDLE;
        } else if (newState.compareTo("Ok") == 0) {
            this.state = Constants.LightStates.OK;
        } else if (newState.compareTo("Busy") == 0) {
            this.state = Constants.LightStates.BUSY;
        } else if (newState.compareTo("Alert") == 0) {
            this.state = Constants.LightStates.ALERT;
        } else {
            throw new IllegalArgumentException("Illegal Light Status");
        }
    }

    @Override
    public INDIElementListener getDefaultUIComponent() throws INDIException {
        if (this.uiComponent != null) {
            this.removeINDIElementListener(this.uiComponent);
        }
        this.uiComponent = INDIViewCreator.getDefault().createLightElementView(this, this.getProperty().getPermission());
        this.addINDIElementListener(this.uiComponent);
        return this.uiComponent;
    }

    @Override
    public boolean checkCorrectValue(Object desiredValue) throws INDIValueException {
        return true;
    }

    @Override
    public String getNameAndValueAsString() {
        return this.getName() + " - " + this.getValue();
    }

    @Override
    public Object getDesiredValue() {
        throw new UnsupportedOperationException("Lights have no desired value");
    }

    @Override
    public void setDesiredValue(Object desiredValue) throws INDIValueException {
        throw new INDIValueException(this, "Lights cannot be set.");
    }

    @Override
    public boolean isChanged() {
        return false;
    }

    @Override
    protected OneElement<?> getXMLOneElementNewValue() {
        LOG.error("changed but not possible, it should not be possible to change a light!");
        return null;
    }

    public String toString() {
        return this.getName() + ": " + this.getValue();
    }

    @Override
    public String getValueAsString() {
        return this.getValue() + "";
    }
}

