/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.auxelex;

import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.auxelex.PduCommon;
import org.lsst.ccs.drivers.auxelex.TestSrp;
import org.lsst.ccs.drivers.commons.DriverException;

public class TestPduCommon
extends TestSrp {
    protected final PduCommon pdu;

    public TestPduCommon(PduCommon pdu) {
        super(pdu);
        this.pdu = pdu;
    }

    @Command(description="Turn on the main power")
    public void mainOn() throws DriverException {
        this.pdu.setMainOn();
    }

    @Command(description="Turn off the main power")
    public void mainOff() throws DriverException {
        this.pdu.setMainOff();
    }

    @Command(description="Get the main power state")
    public String showMain() throws DriverException {
        return this.pdu.isMainOn() ? "on" : "off";
    }

    @Command(description="Show the main power status")
    public String showMainStatus() throws DriverException {
        return String.format("0x%02x", this.pdu.getMainStatus());
    }

    @Command(description="Turn on a channel")
    public void channelOn(@Argument(description="Channel number") int chan) throws DriverException {
        this.pdu.powerOn(chan);
    }

    @Command(description="Turn on a named channel")
    public void channelOnN(@Argument(description="Channel name") String chan) throws DriverException {
        this.pdu.powerOn(chan);
    }

    @Command(description="Turn off a channel")
    public void channelOff(@Argument(description="Channel number") int chan) throws DriverException {
        this.pdu.powerOff(chan);
    }

    @Command(description="Turn off a named channel")
    public void channelOffN(@Argument(description="Channel name") String chan) throws DriverException {
        this.pdu.powerOff(chan);
    }

    @Command(description="Show the state of a channel")
    public String showChannel(@Argument(description="Channel number") int chan) throws DriverException {
        return this.pdu.isPowered(chan) ? "on" : "off";
    }

    @Command(description="Show the state of a named channel")
    public String showChannelN(@Argument(description="Channel name") String chan) throws DriverException {
        return this.pdu.isPowered(chan) ? "on" : "off";
    }

    @Command(description="Show the valid channel mask")
    public String showValidChannels() throws DriverException {
        return String.format("0x%06x", this.pdu.getValidChannels());
    }

    @Command(description="Show the channel switch status")
    public String showSwitchStatus() throws DriverException {
        return String.format("0x%06x", this.pdu.getPoweredStatus());
    }

    @Command(description="Show the channel alert status")
    public String showAlertStatus() throws DriverException {
        return String.format("0x%06x", this.pdu.getAlertStatus());
    }

    @Command(description="Show the link fault word")
    public int showLinkFault() throws DriverException {
        return this.pdu.getLinkFault();
    }

    @Command(description="Read a channel's voltage")
    public double readVoltage(@Argument(description="Channel number") int chan) throws DriverException {
        return this.pdu.readVoltage(chan);
    }

    @Command(description="Read a channel's current")
    public double readCurrent(@Argument(description="Channel number") int chan) throws DriverException {
        return this.pdu.readCurrent(chan);
    }

    @Command(description="Show the channel names")
    public String showChannelNames() throws DriverException {
        StringBuilder text = new StringBuilder();
        String[] names = this.pdu.getChannelNames();
        String prefix = "";
        for (String name : names) {
            text.append(prefix).append(name == null ? "-" : name);
            prefix = " ";
        }
        return text.toString();
    }

    @Command(description="Show the complete power state")
    public String showPower() throws DriverException {
        StringBuilder text = new StringBuilder("Chan   Name      State  Alert  Volts   mAmps");
        String[] names = this.pdu.getChannelNames();
        int mask = this.pdu.getValidChannels();
        int alerts = this.pdu.getAlertStatus();
        int chan = 0;
        while (mask != 0) {
            if ((mask & 1) != 0) {
                text.append(String.format("\n %2s  %-11s  %3s    %3s   %5.2f  %6.1f", chan, names[chan], this.pdu.isPowered(chan) ? " on" : "off", (alerts & 1) != 0 ? " on" : "off", this.pdu.readVoltage(chan), 1000.0 * this.pdu.readCurrent(chan)));
            }
            ++chan;
            mask >>= 1;
            alerts >>= 1;
        }
        return text.toString();
    }
}

