/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.image;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.utilities.image.HeaderSpecification;
import org.lsst.ccs.utilities.logging.Logger;

public class FitsHeadersSpecificationsBuilder {
    private final Map<String, HeaderSpecification> headerSpecificationsMap = new LinkedHashMap<String, HeaderSpecification>();
    public static final Logger log = Logger.getLogger((String)"org.lsst.ccs.utilities.image");

    public final void addSpecFile(String fileName) {
        this.readHeaderSpecification(fileName, null);
    }

    public final void addSpecFile(String fileName, String headerName) {
        this.readHeaderSpecification(fileName, headerName);
    }

    public final Map<String, HeaderSpecification> getHeaderSpecifications() {
        return Collections.unmodifiableMap(this.headerSpecificationsMap);
    }

    private void readHeaderSpecification(String name, String headerName) throws RuntimeException {
        Object fileName;
        Object object = fileName = name.endsWith(".spec") ? name : name + ".spec";
        if (headerName == null) {
            headerName = ((String)fileName).replace(".spec", "");
        }
        try (InputStream bootstrapResource = BootstrapResourceUtils.getBootstrapResource((String)fileName);){
            if (bootstrapResource == null) {
                log.severe((Object)("Failed to open spec file " + (String)fileName));
                return;
            }
            HeaderSpecification desc = null;
            if (this.headerSpecificationsMap.containsKey(headerName)) {
                desc = this.headerSpecificationsMap.get(headerName);
                desc.loadHeaderSpecification(bootstrapResource);
            } else {
                desc = new HeaderSpecification(headerName, bootstrapResource);
                this.headerSpecificationsMap.put(headerName, desc);
            }
            log.log(Level.FINE, "Loaded fits header spec file {0}. Already loaded spec files: {1}", new Object[]{headerName, this.headerSpecificationsMap.keySet()});
        }
        catch (IOException x) {
            throw new RuntimeException("Error reading " + (String)fileName, x);
        }
    }
}

