import org.lsst.ccs.subsystems.fcs.*
import org.lsst.ccs.subsystems.fcs.testbench.*
import org.lsst.ccs.subsystems.fcs.common.*
import org.lsst.ccs.subsystems.fcs.drivers.*
import org.lsst.ccs.drivers.canopenjni.*
import org.lsst.ccs.drivers.canopenjni.rmi.*
import org.lsst.ccs.description.groovy.CCSBuilder

// testAC1 to debug PDO issues with controllers
CCSBuilder builder = ["run-debugAC1"]

def acPlutoGatewayName = "acSensorsGateway" // to monitor the autochanger sensors

builder.
    main ( MainModule,
        bridge:ref("tcpProxy"),
    )

//begin description of Main submodules
{       
    // tcp Proxy
    tcpProxy (CanOpenProxy, hardwareBootTimeout:1000) {
        
            canInterface(CanOpenCommands, coi:new CanOpenRMIClient("134.158.16.230", "canbus0"));
            // can open devices
            //sensors gateway
            "$acPlutoGatewayName" (CanOpenPlutoGateway, nodeID:0x3a,serialNB:"446b")
            
            onlineStrainGauge (CanOpenStrainGauge, nodeID: 0x21, serialNB:"0")
            // can open motor controllers
            linearRailMasterController (CanOpenEPOSLinearRailTruck, 
                nodeID:0x2a,serialNB:"80010977",
            )

            // can open devices
            linearRailSlaveController (CanOpenEPOSLinearRailTruck,
                nodeID:0x2c,serialNB:"80011011",
            )     

            latchXminusController (CanOpenEPOS,  //CanOpenEPOS24-3
                nodeID:0xf,serialNB:"84010184",
            )

            // can open devices
            latchXplusController (CanOpenEPOS,  //CanOpenEPOS24-3
                nodeID:0xe, serialNB:"84010169",
            )

            // can open devices
            onlineClampXminusController (CanOpenEPOSOnlineClamp, 
                nodeID:0x31,serialNB:"79026501",
            )
            // can open devices
            onlineClampXplusController (CanOpenEPOSOnlineClamp, 
                nodeID:0x30, serialNB:"79026465",
            )
            // can open devices
            onlineClampYminusController (CanOpenEPOSOnlineClamp, 
                nodeID:0x32, serialNB:"79026475",
            )
            
             //Devices which are the same classes for hardware and for simulation
            brakeSystemGateway (CanOpenPlutoGateway, nodeID:0x2b,serialNB:"4472")
            tempSensorsDevice (CanOpenSystecIO, nodeID: 0x20, serialNB:"4bb6b")
            proximitySensorsDevice (CanCBXAI420, nodeID: 0x22, serialNB:"c7c60364")

    }//end description of bridge0's children
    
}//end description of Main submodules




