import org.lsst.ccs.description.groovy.CCSBuilder
import org.lsst.ccs.subsystem.motorplatform.ts8.TS8Main
import org.lsst.ccs.subsystem.motorplatform.ts8.ACR9000
import org.lsst.ccs.subsystem.motorplatform.ts8.Axis

import static org.lsst.ccs.drivers.parker.AxisName.AXIS0
import static org.lsst.ccs.drivers.parker.AxisName.AXIS1
import static org.lsst.ccs.drivers.parker.AxisName.AXIS2

CCSBuilder builder = ["ts8-motorplatform"]

builder.
    main(TS8Main) {
        Controller(ACR9000) {
            // Axis names and numbers must match
            XAxis(Axis, axisName:"X", enumName:AXIS0, units:"mm")
            YAxis(Axis, axisName:"Y", enumName:AXIS1, units:"mm")
            ZAxis(Axis, axisName:"Z", enumName:AXIS2, units:"mm")
        }
    }
