/*
 * Decompiled with CFR 0.152.
 */
package rpc.ncacn_np;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.UnknownHostException;
import java.util.Properties;
import jcifs.Config;
import jcifs.netbios.NbtAddress;
import jcifs.smb.SmbNamedPipe;
import ndr.NdrBuffer;
import rpc.ConnectionOrientedEndpoint;
import rpc.Endpoint;
import rpc.ProviderException;
import rpc.RpcException;
import rpc.Transport;
import rpc.core.PresentationSyntax;

public class RpcTransport
implements Transport {
    public static final String PROTOCOL = "ncacn_np";
    private static final String LOCALHOST;
    private String address;
    private Properties properties;
    private SmbNamedPipe pipe;
    OutputStream out;
    InputStream in;
    InputStream in2;
    private int writeSize;
    private int readSize;
    private boolean attached;
    private boolean first;

    public RpcTransport(String address, Properties properties) throws ProviderException {
        this.properties = properties;
        this.parse(address);
    }

    @Override
    public String getProtocol() {
        return PROTOCOL;
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public Endpoint attach(PresentationSyntax syntax) throws IOException {
        if (this.attached) {
            throw new RpcException("Transport already attached.");
        }
        this.pipe = new SmbNamedPipe(this.address, 1536);
        this.in2 = this.pipe.getInputStream();
        this.out = this.pipe.getNamedPipeOutputStream();
        this.in = this.pipe.getNamedPipeInputStream();
        this.attached = true;
        return new ConnectionOrientedEndpoint(this, syntax);
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.pipe != null) {
                this.in.close();
                this.out.close();
                this.in2.close();
            }
        }
        finally {
            this.attached = false;
            this.pipe = null;
        }
    }

    @Override
    public void send(NdrBuffer buffer) throws IOException {
        if (!this.attached) {
            throw new RpcException("Transport not attached.");
        }
        this.out.write(buffer.getBuffer(), 0, buffer.getLength());
        this.first = true;
    }

    @Override
    public void receive(NdrBuffer buffer) throws IOException {
        int n;
        byte[] buf = buffer.getBuffer();
        int off = 0;
        if (!this.attached) {
            throw new RpcException("Transport not attached.");
        }
        if (this.first) {
            n = this.in.read(buf, 0, 1024);
            this.first = false;
        } else {
            n = this.in2.read(buf, off, buf.length);
        }
        buffer.setIndex(8);
        int bytes_to_read = buffer.dec_ndr_short();
        off += n;
        bytes_to_read -= n;
        while (bytes_to_read > 0) {
            n = this.in2.read(buf, off, bytes_to_read);
            off += n;
            bytes_to_read -= n;
        }
        buffer.length = off;
    }

    protected void parse(String address) throws ProviderException {
        Properties properties;
        if (address == null) {
            throw new ProviderException("Null address.");
        }
        if (!address.startsWith("ncacn_np:")) {
            throw new ProviderException("Not an ncacn_np address.");
        }
        int index = (address = address.substring(9)).indexOf(91);
        if (index == -1) {
            throw new ProviderException("No port specifier present.");
        }
        String server = address.substring(0, index);
        if ((index = (address = address.substring(index + 1)).indexOf(93)) == -1) {
            throw new ProviderException("Port specifier not terminated.");
        }
        address = address.substring(0, index);
        while (address.startsWith("\\")) {
            address = address.substring(1);
        }
        if (!address.regionMatches(true, 0, "PIPE", 0, 4)) {
            throw new ProviderException("Not a named pipe address.");
        }
        address = address.substring(4);
        while (address.startsWith("\\")) {
            address = address.substring(1);
        }
        if ("".equals(address)) {
            throw new ProviderException("Empty port.");
        }
        while (server.startsWith("\\")) {
            server = server.substring(1);
        }
        if ("".equals(server)) {
            server = LOCALHOST;
        }
        if ((properties = this.getProperties()) != null) {
            String userInfo = properties.getProperty("rpc.ncacn_np.username");
            if (userInfo == null) {
                userInfo = Config.getProperty("jcifs.smb.client.username");
            }
            if (userInfo != null) {
                String password;
                String domain = properties.getProperty("rpc.ncacn_np.domain");
                if (domain == null) {
                    domain = Config.getProperty("jcifs.smb.client.domain");
                }
                if (domain != null) {
                    userInfo = domain + ';' + userInfo;
                }
                if ((password = properties.getProperty("rpc.ncacn_np.password")) == null) {
                    password = Config.getProperty("jcifs.smb.client.password");
                }
                if (password != null) {
                    userInfo = userInfo + ':' + password;
                }
            }
            if (userInfo != null) {
                server = userInfo + '@' + server;
            }
        }
        this.address = "smb://" + server + "/IPC$/" + address;
    }

    static {
        String localhost = null;
        try {
            localhost = NbtAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        LOCALHOST = localhost;
    }
}

