/*
 * Decompiled with CFR 0.152.
 */
package org.jinterop.dcom.core;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.logging.Level;
import jcifs.util.Hexdump;
import ndr.NdrObject;
import ndr.NetworkDataRepresentation;
import org.jinterop.dcom.common.JISystem;
import org.jinterop.dcom.core.JIMarshalUnMarshalHelper;
import org.jinterop.dcom.core.JIObjectId;

class PingObject
extends NdrObject {
    int opnum = -1;
    ArrayList listOfAdds = new ArrayList();
    ArrayList listOfDels = new ArrayList();
    byte[] setId = null;
    int seqNum = 0;

    PingObject() {
    }

    @Override
    public int getOpnum() {
        return this.opnum;
    }

    @Override
    public void write(NetworkDataRepresentation ndr) {
        switch (this.opnum) {
            case 2: {
                int newlength = 22 + this.listOfAdds.size() * 8 + 8 + this.listOfDels.size() * 8 + 16;
                if (newlength > ndr.getBuffer().buf.length) {
                    ndr.getBuffer().buf = new byte[newlength + 16];
                }
                if (this.setId == null) {
                    if (JISystem.getLogger().isLoggable(Level.INFO)) {
                        JISystem.getLogger().info("Complex Ping going for the first time, will get the setId as response of this call ");
                    }
                    this.setId = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
                } else {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    Hexdump.hexdump(new PrintStream(byteArrayOutputStream), this.setId, 0, this.setId.length);
                    if (JISystem.getLogger().isLoggable(Level.INFO)) {
                        JISystem.getLogger().info("Complex Ping going for setId: " + byteArrayOutputStream.toString());
                    }
                }
                if (JISystem.getLogger().isLoggable(Level.INFO)) {
                    JISystem.getLogger().info("Complex ping going : listOfAdds -> Size : " + this.listOfAdds.size() + " , " + this.listOfAdds);
                    JISystem.getLogger().info("listOfDels -> Size : " + this.listOfDels.size() + " , " + this.listOfDels);
                }
                JIMarshalUnMarshalHelper.writeOctetArrayLE(ndr, this.setId);
                JIMarshalUnMarshalHelper.serialize(ndr, Short.class, new Short((short)this.seqNum), null, 0);
                JIMarshalUnMarshalHelper.serialize(ndr, Short.class, new Short((short)this.listOfAdds.size()), null, 0);
                JIMarshalUnMarshalHelper.serialize(ndr, Short.class, new Short((short)this.listOfDels.size()), null, 0);
                if (this.listOfAdds.size() > 0) {
                    JIMarshalUnMarshalHelper.serialize(ndr, Integer.class, new Integer(new Object().hashCode()), null, 0);
                    JIMarshalUnMarshalHelper.serialize(ndr, Integer.class, new Integer(this.listOfAdds.size()), null, 0);
                    for (int i = 0; i < this.listOfAdds.size(); ++i) {
                        JIObjectId oid = (JIObjectId)this.listOfAdds.get(i);
                        JIMarshalUnMarshalHelper.writeOctetArrayLE(ndr, oid.getOID());
                    }
                } else {
                    JIMarshalUnMarshalHelper.serialize(ndr, Integer.class, new Integer(0), null, 0);
                }
                if (this.listOfDels.size() > 0) {
                    JIMarshalUnMarshalHelper.serialize(ndr, Integer.class, new Integer(new Object().hashCode()), null, 0);
                    JIMarshalUnMarshalHelper.serialize(ndr, Integer.class, new Integer(this.listOfDels.size()), null, 0);
                    double index = new Integer(ndr.getBuffer().getIndex()).doubleValue();
                    long k = Math.round(index % 8.0);
                    k = k == 0L ? 0L : 8L - k;
                    ndr.writeOctetArray(new byte[(int)k], 0, (int)k);
                    for (int i = 0; i < this.listOfDels.size(); ++i) {
                        JIObjectId oid = (JIObjectId)this.listOfDels.get(i);
                        JIMarshalUnMarshalHelper.writeOctetArrayLE(ndr, oid.getOID());
                    }
                } else {
                    JIMarshalUnMarshalHelper.serialize(ndr, Integer.class, new Integer(0), null, 0);
                }
                JIMarshalUnMarshalHelper.serialize(ndr, Integer.class, new Integer(0), null, 0);
                JIMarshalUnMarshalHelper.serialize(ndr, Integer.class, new Integer(0), null, 0);
                JIMarshalUnMarshalHelper.serialize(ndr, Integer.class, new Integer(0), null, 0);
                JIMarshalUnMarshalHelper.serialize(ndr, Integer.class, new Integer(0), null, 0);
                break;
            }
            case 1: {
                if (this.setId != null) {
                    JIMarshalUnMarshalHelper.writeOctetArrayLE(ndr, this.setId);
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    Hexdump.hexdump(new PrintStream(byteArrayOutputStream), this.setId, 0, this.setId.length);
                    if (!JISystem.getLogger().isLoggable(Level.INFO)) break;
                    JISystem.getLogger().info("Simple Ping going for setId: " + byteArrayOutputStream.toString());
                    break;
                }
                if (!JISystem.getLogger().isLoggable(Level.INFO)) break;
                JISystem.getLogger().info("Some error ! Simple ping requested , but has no setID ");
                break;
            }
        }
    }

    @Override
    public void read(NetworkDataRepresentation ndr) {
        switch (this.opnum) {
            case 2: {
                this.setId = JIMarshalUnMarshalHelper.readOctetArrayLE(ndr, 8);
                JIMarshalUnMarshalHelper.deSerialize(ndr, Short.class, null, 0, null);
                int hresult = (Integer)JIMarshalUnMarshalHelper.deSerialize(ndr, Integer.class, null, 0, null);
                if (hresult != 0) {
                    if (!JISystem.getLogger().isLoggable(Level.SEVERE)) break;
                    JISystem.getLogger().severe("Some error ! Complex ping failed , hresult: " + hresult);
                    break;
                }
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                Hexdump.hexdump(new PrintStream(byteArrayOutputStream), this.setId, 0, this.setId.length);
                if (!JISystem.getLogger().isLoggable(Level.INFO)) break;
                JISystem.getLogger().info("Complex Ping Succeeded,  setId is : " + byteArrayOutputStream.toString());
                break;
            }
            case 1: {
                int hresult = (Integer)JIMarshalUnMarshalHelper.deSerialize(ndr, Integer.class, null, 0, null);
                if (hresult != 0) {
                    if (!JISystem.getLogger().isLoggable(Level.SEVERE)) break;
                    JISystem.getLogger().severe("Some error ! Simple ping failed , hresult: " + hresult);
                    break;
                }
                if (!JISystem.getLogger().isLoggable(Level.INFO)) break;
                JISystem.getLogger().info("Simple Ping Succeeded");
                break;
            }
        }
    }
}

