/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.power;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.drivers.auxelex.RebBulkPS;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.subsystem.common.ErrorUtils;
import org.lsst.ccs.subsystem.power.SwitchControl;

public class RebBulkPsDevice
extends Device
implements SwitchControl {
    private static final Logger LOG = Logger.getLogger(RebBulkPsDevice.class.getName());
    protected static final int MON_TYPE_VOLTAGE = 0;
    protected static final int MON_TYPE_CURRENT = 1;
    protected static final int MON_TYPE_TEMP = 2;
    protected static final int MON_TYPE_BOARD_TEMP = 3;
    private static final String NODE = "node";
    private static final Map<String, Integer> mTypeMap = new HashMap<String, Integer>();
    @ConfigurationParameter(name="node", category="Quadbox", isFinal=true)
    protected volatile Integer node;
    private final RebBulkPS ps = new RebBulkPS();
    private boolean initError = false;

    protected void initDevice() {
        if (this.node == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)NODE, (String)"is missing");
        }
        this.fullName = "REB bulk PS board (" + this.node + ")";
    }

    public void initialize() {
        block2: {
            try {
                this.ps.open(this.node.intValue());
                this.setOnline(true);
                this.initSensors();
                LOG.log(Level.INFO, "Connected to {0}", this.fullName);
                this.initError = false;
            }
            catch (DriverException e) {
                if (this.initError) break block2;
                LOG.log(Level.SEVERE, "Error connecting to {0}: {1}", new Object[]{this.fullName, e});
                this.initError = true;
            }
        }
    }

    protected void close() {
        try {
            this.ps.close();
        }
        catch (DriverException e) {
            LOG.log(Level.SEVERE, "Error disconnecting from {0}:{1}", new Object[]{this.fullName, e});
        }
    }

    protected int[] checkChannel(String name, int hwChan, String type, String subtype) throws Exception {
        Integer mType = mTypeMap.get(type.toUpperCase());
        if (mType == null) {
            ErrorUtils.reportChannelError((Logger)LOG, (String)name, (String)"type", (Object)type);
        }
        if (mType != 3 && (hwChan < 0 || hwChan >= 5)) {
            ErrorUtils.reportChannelError((Logger)LOG, (String)name, (String)"hwChan", (Object)hwChan);
        }
        return new int[]{mType, 0};
    }

    protected double readChannel(int hwChan, int type) {
        double value = Double.NaN;
        String item = null;
        if (this.online) {
            try {
                switch (type) {
                    case 0: {
                        item = "voltage";
                        value = this.ps.readVoltage(hwChan);
                        break;
                    }
                    case 1: {
                        item = "current";
                        value = this.ps.readCurrent(hwChan);
                        break;
                    }
                    case 2: {
                        item = "temperature";
                        value = this.ps.readTemperature(hwChan);
                        break;
                    }
                    case 3: {
                        item = "board temperature";
                        value = this.ps.readBoardTemperature();
                    }
                }
            }
            catch (DriverException e) {
                LOG.log(Level.SEVERE, "Error reading {0} {1}: {2}", new Object[]{this.fullName, item, e});
                this.setOnline(false);
            }
        }
        return value;
    }

    @Override
    public int getSwitchDevice() {
        return 5;
    }

    @Override
    public void switchOn(int psNum) {
        try {
            this.ps.setPowerOn(psNum, true);
        }
        catch (DriverException e) {
            LOG.log(Level.SEVERE, "Error switching on PS {0} on {1}: {2}", new Object[]{psNum, this.fullName, e});
        }
    }

    @Override
    public void switchOff(int psNum) {
        try {
            this.ps.setPowerOn(psNum, false);
        }
        catch (DriverException e) {
            LOG.log(Level.SEVERE, "Error switching off PS {0} on {1}: {2}", new Object[]{psNum, this.fullName, e});
        }
    }

    @Override
    public Boolean isSwitchOn(int psNum) {
        if (!this.online || psNum < 0) {
            return null;
        }
        try {
            return (this.ps.getIoStatus(psNum) & 1) != 0;
        }
        catch (DriverException e) {
            LOG.log(Level.SEVERE, "Error getting IO status for PS {0} on {1}: {2}", new Object[]{psNum, this.fullName, e});
            return null;
        }
    }

    static {
        mTypeMap.put("VOLTAGE", 0);
        mTypeMap.put("CURRENT", 1);
        mTypeMap.put("TEMP", 2);
        mTypeMap.put("BOARDTEMP", 3);
    }
}

