/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.daq;

import java.time.Duration;
import java.util.logging.Logger;
import org.lsst.ccs.Agent;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.RunMode;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.daq.ims.DAQException;
import org.lsst.ccs.framework.AgentPeriodicTask;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.subsystem.common.ErrorUtils;
import org.lsst.ccs.subsystem.daq.DaqStatsMonitor;
import org.lsst.ccs.subsystem.daq.DaqStoreManageDevice;

public class DaqSubsystem
extends Subsystem
implements HasLifecycle {
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private DaqStoreManageDevice store;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private DaqStatsMonitor stats;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPeriodicTaskService periodicTaskService;
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Agent agent;
    @LookupName
    private String name;
    private static final Logger LOG = Logger.getLogger(DaqSubsystem.class.getName());
    private final Duration autoPurgeInterval = Duration.ofMinutes(15L);
    @ConfigurationParameter(isFinal=true, category="Store", description="partition containing DAQ store")
    private volatile String daqPartition;

    public DaqSubsystem() {
        super("daqsub", AgentInfo.AgentType.WORKER);
        this.getAgentInfo().getAgentProperties().setProperty("org.lsst.ccs.use.full.paths", "true");
    }

    public void build() {
        Runnable purgeDAQ = new Runnable(){

            @Override
            public void run() {
                try {
                    DaqSubsystem.this.store.autoPurge();
                }
                catch (DAQException ex) {
                    LOG.severe("DAQExceptiom during attempted sutoPurge: " + (Object)((Object)ex));
                }
            }
        };
        AgentPeriodicTask purgeTask = new AgentPeriodicTask("purgeDAQ", purgeDAQ).withPeriod(this.autoPurgeInterval);
        this.periodicTaskService.scheduleAgentPeriodicTask(purgeTask);
    }

    public void init() {
        if (this.daqPartition == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"daqPartition", (String)"value is missing");
        }
        this.store.setPartition(this.daqPartition);
        this.stats.setPartition(this.daqPartition);
    }

    public void postInit() {
    }

    public void start() {
        if (!RunMode.isSimulation()) {
            if (!this.store.isOnline()) {
                throw new RuntimeException("DAQ store not connected");
            }
            if (!this.stats.isOnline()) {
                throw new RuntimeException("DAQ stats not connected");
            }
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, name="purge", description="Purge older files in DAQ two-day store")
    public void purge() throws DAQException {
        this.store.purge();
    }
}

