/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.teststand;

import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.microion.MicroIon;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.monitor.MonitorLogUtils;
import org.lsst.ccs.subsystem.teststand.VacuumGaugeDevice;
import org.lsst.ccs.subsystem.teststand.data.TSConfig;
import org.lsst.ccs.subsystem.teststand.data.TSState;
import org.lsst.ccs.utilities.logging.Logger;

public class MicroIonDevice
extends Device
implements VacuumGaugeDevice {
    private static final Map<String, Integer> typeMap = new HashMap<String, Integer>();
    private MicroIon microDev;
    TSConfig cfg = new TSConfig();
    private double[] runVac = new double[TSConfig.MAXSTATES];
    TSState.vacstates vstate = TSState.vacstates.NOTCONFIGURED;
    boolean isConnected = false;
    boolean failedToInitialize = false;
    double lastPres = 0.0;

    public MicroIonDevice() {
    }

    public MicroIonDevice(int itype, String host, int port, int addr) throws DriverException {
        try {
            this.microDev = new MicroIon();
            this.microDev.openftdi(host, port, addr);
            this.vstate = TSState.vacstates.OFF;
            this.isConnected = true;
        }
        catch (DriverException e) {
            System.out.println("Failed to open connection to MicroIon device!");
        }
    }

    @Override
    @Command(name="isVacuumGaugeOn", description="returns whether the MicroIon device is active")
    public boolean isVacuumGaugeOn() {
        boolean state = false;
        try {
            boolean bl = state = this.microDev.getState() == MicroIon.onOff.ON;
            if (!this.vstate.equals((Object)TSState.vacstates.TRIPPED)) {
                this.vstate = state ? TSState.vacstates.ON : TSState.vacstates.OFF;
            }
        }
        catch (DriverException e) {
            this.log.error((Object)"MicroIon device failed to respond to status request!!!");
        }
        return state;
    }

    @Override
    @Command(name="setGaugeOn", description="turn on power to the vacuum gauge filament")
    public void setGaugeOn() {
        try {
            if (this.microDev != null) {
                this.microDev.setState(1);
            }
        }
        catch (DriverException e) {
            this.log.error((Object)"MicroIon device failed to turn on!!!");
        }
    }

    @Override
    @Command(name="setGaugeOff", description="turn off power to the vacuum gauge filament")
    public void setGaugeOff() {
        try {
            if (this.microDev != null) {
                this.microDev.setState(0);
            }
        }
        catch (DriverException e) {
            this.log.error((Object)"MicroIon device failed to turn off!!!");
        }
    }

    @Override
    @Command(type=Command.CommandType.QUERY, name="readPressure", description="returns the pressure read from the MicroIon device")
    public double readPressure() {
        double pressure = 0.0;
        try {
            if (this.isConnected) {
                pressure = this.microDev.getPressure();
                if (pressure > 0.0 && pressure < 2000.0) {
                    this.lastPres = pressure;
                } else {
                    pressure = 0.0;
                }
            }
        }
        catch (DriverException e) {
            this.log.debug((Object)"MicroIon device failed to return pressure reading!!!");
            System.out.print("P");
            pressure = this.lastPres;
        }
        return pressure;
    }

    @Override
    @Command(name="getLastPressure", description="returns the last successful pressure read from the TPG261 device")
    public double getLastPres() {
        return this.lastPres;
    }

    protected void close() {
        try {
            if (this.microDev != null) {
                this.microDev.close();
            }
        }
        catch (DriverException e) {
            this.log.error((Object)"MicroIon device failed to close!!!");
        }
    }

    protected void initialize() {
        if (this.isConnected) {
            try {
                this.log.debug((Object)("State of of the MicroIon device is " + (this.microDev.getState() == MicroIon.onOff.ON ? "ON" : "OFF")));
                this.log.debug((Object)"MicroIon device initialized.");
                this.setOnline(true);
                this.vstate = TSState.vacstates.OK;
            }
            catch (DriverException e) {
                if (!this.failedToInitialize) {
                    this.log.error((Object)"MicroIon device failed to initialize!!!");
                }
                this.failedToInitialize = true;
                this.isConnected = false;
            }
        }
    }

    protected int[] checkChannel(String name, int hwChan, String type, String subtype) throws Exception {
        Integer iType = typeMap.get(type.toUpperCase());
        if (iType == null) {
            MonitorLogUtils.reportError((Logger)this.log, (String)name, (String)"type", (Object)type);
        } else if (iType != -1) {
            MonitorLogUtils.reportError((Logger)this.log, (String)name, (String)"Wrong channel type specified! type = ", (Object)type);
        }
        return new int[]{iType, 0};
    }

    protected void initChannel(int chan, int type, int subtype) {
    }

    protected double readChannel(int chan, int type) {
        double value = Double.NaN;
        try {
            value = this.readPressure();
        }
        catch (Exception e) {
            this.log.debug((Object)("Error reading channel type " + type + ": " + e));
            System.out.print("P");
        }
        return value;
    }

    @Override
    @Command(name="setRunVac", description="Sets the vac value for acquisition")
    public void setRunVac(double runVac, int cfgstate) {
        this.runVac[cfgstate] = runVac;
    }

    @Override
    @Command(name="getRunVac", description="Returns the vac value for acquisition")
    public double getRunVac(int cfgstate) {
        return this.runVac[cfgstate];
    }

    @Override
    @Command(name="setstate", description="set vacuum device status")
    public void setState(int istate) {
        this.vstate = TSState.vacstates.values()[istate];
    }

    @Override
    @Command(name="getState", description="get vacuum device status")
    public int getState() {
        return this.vstate.ordinal();
    }

    static {
        typeMap.put("TEMP", 0);
        typeMap.put("VOLTS", 1);
        typeMap.put("CURR", 2);
        typeMap.put("PRESSURE", -1);
        typeMap.put("WAVELENGTH", 3);
        typeMap.put("PA", -1);
    }
}

