/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.teststand;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.ConfigurationParameterChanger;
import org.lsst.ccs.drivers.commons.DriverConstants;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.cryocon.M24C;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.monitor.MonitorLogUtils;
import org.lsst.ccs.subsystem.teststand.CryoDevice;
import org.lsst.ccs.subsystem.teststand.data.TSConfig;
import org.lsst.ccs.subsystem.teststand.data.TSState;
import org.lsst.ccs.utilities.logging.Logger;

public class CryoCon24cDevice
extends Device
implements CryoDevice {
    public static final int CHAN_CURR_TEMP = 0;
    public static final int CHAN_RUN_TEMP = 1;
    public static final int CHAN_TEMP_STDDEV = 2;
    public static final int CHAN_HTR_1 = 3;
    public static final int CHAN_HTR_2 = 4;
    public static final int CHAN_TEMP_A = 5;
    public static final int CHAN_TEMP_B = 6;
    public static final int CHAN_TEMP_C = 7;
    public static final int CHAN_TEMP_D = 8;
    public static final int CHAN_PID_P_1 = 9;
    public static final int CHAN_PID_I_1 = 10;
    public static final int CHAN_PID_D_1 = 11;
    public static final int CHAN_PID_P_2 = 12;
    public static final int CHAN_PID_I_2 = 13;
    public static final int CHAN_PID_D_2 = 14;
    public static final int CHAN_TEMP_CHNG = 15;
    public static final int CHAN_SETPOINT_1 = 16;
    public static final int CHAN_SETPOINT_2 = 17;
    public static final int NUM_CHANS = 18;
    private static final Set<String> channels = new HashSet<String>();
    private static final int EVENT_ID_CRYO = 0;
    TSConfig cfg = new TSConfig();
    private double[] RUN_TEMP = new double[TSConfig.MAXSTATES];
    private TSState.cryostates cstate;
    private final M24C m24c = new M24C();
    public String current_channel = "B";
    public String current_channel2 = "C";
    public int current_loop = 1;
    List<Double> temperature_data_A = new ArrayList<Double>();
    List<Double> temperature_time_A = new ArrayList<Double>();
    List<Double> temperature_data_B = new ArrayList<Double>();
    List<Double> temperature_time_B = new ArrayList<Double>();
    List<Double> temperature_data_C = new ArrayList<Double>();
    List<Double> temperature_time_C = new ArrayList<Double>();
    List<Double> temperature_data_D = new ArrayList<Double>();
    List<Double> temperature_time_D = new ArrayList<Double>();
    Map<String, List<Double>> tempDataMap = new HashMap<String, List<Double>>();
    Map<String, List<Double>> tempTimeMap = new HashMap<String, List<Double>>();
    private final Logger log = Logger.getLogger((String)this.getClass().getPackage().getName());
    @ConfigurationParameter
    protected volatile double[] maxSetPoints;
    @ConfigurationParameter
    protected volatile Map<String, String> channelTypes;
    @ConfigurationParameter
    protected volatile Map<String, String> channelUnits;
    DriverConstants.ConnType connType = DriverConstants.ConnType.NET;
    @ConfigurationParameter(isFinal=true, description="network host address")
    volatile String host;
    int port = 5000;
    @ConfigurationParameter(category="Cryocon", isFinal=true, description="proportional parameter, loop 1")
    protected volatile double p_gainLoop1;
    @ConfigurationParameter(category="Cryocon", isFinal=true, description="integral parameter, loop 1")
    protected volatile double i_gainLoop1;
    @ConfigurationParameter(category="Cryocon", isFinal=true, description="derivative parameter, loop 1")
    protected volatile double d_gainLoop1;
    @ConfigurationParameter(category="Cryocon", isFinal=true, description="proportional parameter, loop 2")
    protected volatile double p_gainLoop2;
    @ConfigurationParameter(category="Cryocon", isFinal=true, description="integral parameter, loop 2")
    protected volatile double i_gainLoop2;
    @ConfigurationParameter(category="Cryocon", isFinal=true, description="derivative parameter, loop 2")
    protected volatile double d_gainLoop2;

    public CryoCon24cDevice() {
        this.cstate = TSState.cryostates.NOTCONFIGURED;
        this.tempDataMap.put("A", this.temperature_data_A);
        this.tempTimeMap.put("A", this.temperature_time_A);
        this.tempDataMap.put("B", this.temperature_data_B);
        this.tempTimeMap.put("B", this.temperature_time_B);
        this.tempDataMap.put("C", this.temperature_data_C);
        this.tempTimeMap.put("C", this.temperature_time_C);
        this.tempDataMap.put("D", this.temperature_data_D);
        this.tempTimeMap.put("D", this.temperature_time_D);
    }

    @ConfigurationParameterChanger(propertyName="maxSetPoints")
    public void setMaxSetPoints(double[] maxSetPoints) throws DriverException {
        if (maxSetPoints == null || maxSetPoints.length != 4) {
            throw new IllegalArgumentException("Invalid maxSetPoints array provided. It must contain four elements.");
        }
        this.maxSetPoints = maxSetPoints;
    }

    @ConfigurationParameterChanger(propertyName="channelTypes")
    public void setChannelTypes(Map<String, String> channelTypes) throws DriverException {
        if (channelTypes == null || !channelTypes.keySet().equals(channels)) {
            throw new IllegalArgumentException("Invalid channelTypes map provided. It must contain entries for all channels.");
        }
        this.channelTypes = channelTypes;
    }

    @ConfigurationParameterChanger(propertyName="channelUnits")
    public void setChannelUnits(Map<String, String> channelUnits) throws DriverException {
        if (channelUnits == null || !channelUnits.keySet().equals(channels)) {
            throw new IllegalArgumentException("Invalid channelUnits map provided. It must contain entries for all channels.");
        }
        this.channelUnits = channelUnits;
    }

    protected void initDevice() {
        if (this.host == null) {
            MonitorLogUtils.reportConfigError((Logger)this.log, (String)this.name, (String)"host", (String)"is not specified");
        }
        if (this.maxSetPoints == null) {
            MonitorLogUtils.reportConfigError((Logger)this.log, (String)this.name, (String)"maxSetPoints", (String)"is not specified");
        }
        if (this.maxSetPoints.length != 4) {
            MonitorLogUtils.reportConfigError((Logger)this.log, (String)this.name, (String)"maxSetPoints", (String)"has wrong length (must be 4)");
        }
        if (this.channelTypes == null) {
            MonitorLogUtils.reportConfigError((Logger)this.log, (String)this.name, (String)"channelTypes", (String)"is not specified");
        }
        if (!this.channelTypes.keySet().equals(channels)) {
            MonitorLogUtils.reportConfigError((Logger)this.log, (String)this.name, (String)"channelTypes", (String)"has invalid keyset");
        }
        if (this.channelUnits == null) {
            MonitorLogUtils.reportConfigError((Logger)this.log, (String)this.name, (String)"channelUnits", (String)"is not specified");
        }
        if (!this.channelUnits.keySet().equals(channels)) {
            MonitorLogUtils.reportConfigError((Logger)this.log, (String)this.name, (String)"channelUnits", (String)"has invalid keyset");
        }
        this.fullName = "Cryocon M24C (" + this.host + ")";
    }

    protected void initialize() {
        block5: {
            try {
                this.m24c.open(this.connType, this.host, this.port);
                for (String channel : this.channelTypes.keySet()) {
                    this.m24c.setType(channel.charAt(0), this.channelTypes.get(channel));
                }
                for (String channel : this.channelUnits.keySet()) {
                    this.m24c.setUnit(channel.charAt(0), this.channelUnits.get(channel).charAt(0));
                }
                for (int l = 0; l < this.maxSetPoints.length; ++l) {
                    this.m24c.setMaxSetPoint(l + 1, this.maxSetPoints[l]);
                }
                this.m24c.writeCommand("LOOP 1:PGAIN " + this.p_gainLoop1);
                this.m24c.writeCommand("LOOP 1:IGAIN " + this.i_gainLoop1);
                this.m24c.writeCommand("LOOP 1:DGAIN " + this.d_gainLoop1);
                this.m24c.writeCommand("LOOP 2:PGAIN " + this.p_gainLoop2);
                this.m24c.writeCommand("LOOP 2:IGAIN " + this.i_gainLoop2);
                this.m24c.writeCommand("LOOP 2:DGAIN " + this.d_gainLoop2);
                this.setOnline(true);
                this.log.info((Object)("Connected to " + this.fullName));
            }
            catch (DriverException e) {
                if (this.inited) break block5;
                this.log.error((Object)("Error connecting to " + this.fullName + ": " + (Object)((Object)e)));
            }
        }
        this.inited = true;
    }

    public void close() {
        try {
            this.m24c.close();
        }
        catch (DriverException e) {
            this.log.error((Object)("Error disconnecting from " + this.fullName + ": " + (Object)((Object)e)));
        }
    }

    protected int[] checkChannel(String name, int hwChan, String type, String subtype) throws Exception {
        if (hwChan < 0 || hwChan >= 18) {
            MonitorLogUtils.reportError((Logger)this.log, (String)name, (String)"hardware channel", (Object)hwChan);
        }
        return new int[]{0, 0};
    }

    protected void initChannel(int chan, int type, int subtype) {
    }

    protected double readChannel(int chan, int type) {
        double value = 0.0;
        try {
            switch (chan) {
                case 0: {
                    value = this.getTemp(this.current_channel);
                    break;
                }
                case 1: {
                    value = this.getRunTemp(1);
                    break;
                }
                case 2: {
                    value = this.getTempStdDev();
                    break;
                }
                case 3: {
                    value = this.m24c.getHtrRead(1);
                    break;
                }
                case 4: {
                    value = this.m24c.getHtrRead(2);
                    break;
                }
                case 5: {
                    value = this.getTemp("A");
                    break;
                }
                case 6: {
                    value = this.getTemp("B");
                    break;
                }
                case 7: {
                    value = this.getTemp("C");
                    break;
                }
                case 8: {
                    value = this.getTemp("D");
                    break;
                }
                case 9: {
                    value = this.m24c.getPID_P(1);
                    break;
                }
                case 10: {
                    value = this.m24c.getPID_I(1);
                    break;
                }
                case 11: {
                    value = this.m24c.getPID_D(1);
                    break;
                }
                case 12: {
                    value = this.m24c.getPID_P(2);
                    break;
                }
                case 13: {
                    value = this.m24c.getPID_I(2);
                    break;
                }
                case 14: {
                    value = this.m24c.getPID_D(2);
                    break;
                }
                case 15: {
                    value = this.getTempChange();
                    break;
                }
                case 16: {
                    value = this.m24c.getSetPoint(1);
                    break;
                }
                case 17: {
                    value = this.m24c.getSetPoint(2);
                }
            }
        }
        catch (DriverException e) {
            this.log.error((Object)("Error reading channel " + chan + ": " + (Object)((Object)e)));
            this.setOnline(false);
        }
        return value;
    }

    public void processAlarm(int event, int parm) {
        this.log.error((Object)("Received alarm for event " + event + " where trip=" + 0 + " and reset=" + 3));
        switch (event) {
            case 0: {
                if (parm != 0) break;
                this.log.error((Object)"Temperature alarm received! Please rectify and reset manually!");
                this.cstate = TSState.cryostates.TRIPPED;
                break;
            }
            case 3: {
                if (parm != 0) break;
                this.cstate = TSState.cryostates.OK;
                break;
            }
        }
    }

    @Command(name="showident", description="Show Temp Control 24C identification")
    public String showIdentification() throws DriverException {
        String[] ident = this.m24c.getIdentification();
        return "Manufacturer:  " + ident[0] + "\nModel name:    " + ident[1] + "\nSerial number: " + ident[2] + "\nF/W version:   " + ident[3];
    }

    @Override
    @Command(type=Command.CommandType.QUERY, name="getMaxSetPoint", description="Retrieve MaxSetPoint for loop")
    public double getMaxSetPoint(@Argument(name="loop", description="loop number [1-4]") int loop) throws DriverException {
        return this.m24c.getMaxSetPoint(loop);
    }

    @Override
    @Command(name="setMaxSetPoint", description="setMaxSetPoint for loop")
    public void setMaxSetPoint(@Argument(name="loop", description="loop number [1-4]") int loop, @Argument(name="temp", description="temperature") double temp) throws DriverException {
        this.m24c.setMaxSetPoint(loop, temp);
    }

    @Override
    @Command(name="getSetPoint", description="Retrieve setPoint for loop")
    public double getSetPoint(@Argument(name="loop", description="loop number [1-4]") int loop) throws DriverException {
        return this.m24c.getSetPoint(loop);
    }

    @Override
    @Command(name="setSetPoint", description="setSetPoint for loop")
    public void setSetPoint(@Argument(name="loop", description="loop number [1-4]") int loop, @Argument(name="temp", description="temperature") double temp) throws DriverException {
        this.m24c.setSetPoint(loop, temp);
    }

    @Override
    @Command(name="getHtrRead", description="Retrieve heater reading for loop")
    public double getHtrRead(@Argument(name="loop", description="loop number [1-4]") int loop) throws DriverException {
        return this.m24c.getHtrRead(loop);
    }

    @Override
    @Command(name="getPID_P", description="Retrieve PID parameter P for loop")
    public double getPID_P(@Argument(name="loop", description="loop number [1-4]") int loop) throws DriverException {
        return this.m24c.getPID_P(loop);
    }

    @Override
    @Command(name="getPID_I", description="Retrieve PID parameter I for loop")
    public double getPID_I(@Argument(name="loop", description="loop number [1-4]") int loop) throws DriverException {
        return this.m24c.getPID_I(loop);
    }

    @Override
    @Command(name="getPID_D", description="Retrieve PID parameter D for loop")
    public double getPID_D(@Argument(name="loop", description="loop number [1-4]") int loop) throws DriverException {
        return this.m24c.getPID_D(loop);
    }

    @Override
    @Command(type=Command.CommandType.QUERY, name="getLoopSource", description="Retrieve source channel for loop")
    public char getLoopSource(@Argument(name="loop", description="loop number [1-4]") int loop) throws DriverException {
        return this.m24c.getSource(loop);
    }

    @Override
    @Command(name="setLoopSource", description="Set source channel for loop")
    public void setLoopSource(@Argument(name="loop", description="loop number [1-4]") int loop, @Argument(name="channel", description="channel [A-D]") String channel) throws DriverException {
        this.m24c.setSource(loop, channel.charAt(0));
    }

    @Command(name="getHeaterRange", description="Get heater range for loop")
    public String getHeaterRange(@Argument(name="loop", description="loop number [1-4]") int loop) throws DriverException {
        return this.m24c.getHeaterRange(loop);
    }

    @Override
    @Command(name="setHeaterRange", description="setHeaterRange for loop")
    public void setHeaterRange(@Argument(name="loop", description="loop number [1-4]") int loop, @Argument(name="range", description="hi,low,mid") String range) throws DriverException {
        this.m24c.setHeaterRange(loop, range);
    }

    @Command(name="getHeaterMax", description="Get maximum heater power for loop")
    public double getHeaterMax(@Argument(name="loop", description="loop number [1-4]") int loop) throws DriverException {
        return this.m24c.getHeaterMax(loop);
    }

    @Command(name="setHeaterMax", description="Set maximum heater power for loop")
    public void setHeaterMax(@Argument(name="loop", description="loop number [1-4]") int loop, @Argument(name="power", description="heater power (%)") double power) throws DriverException {
        this.m24c.setHeaterMax(loop, power);
    }

    @Override
    @Command(type=Command.CommandType.QUERY, name="getTemp", description="Retrieve temperature info")
    public double getTemp(@Argument(name="channel", description="Temp Channel to read") String channel) throws DriverException {
        double value = this.m24c.getTemp(channel.charAt(0));
        if (value > -274.0) {
            List<Double> tempData = this.tempDataMap.get(channel);
            List<Double> tempTime = this.tempTimeMap.get(channel);
            tempData.add(value);
            tempTime.add((double)System.currentTimeMillis() / 60000.0);
            if (tempData.size() > 120) {
                tempData.remove(0);
                tempTime.remove(0);
            }
        }
        return value;
    }

    @Override
    @Command(name="setRunTemp", description="Sets the temp value for acquisition")
    public void setRunTemp(double temp, int cfgstate) {
        this.RUN_TEMP[cfgstate] = temp;
        this.cfg.setCryoTAcq(temp, cfgstate);
    }

    @Override
    @Command(type=Command.CommandType.QUERY, name="getRunTemp", description="Returns the temp value for acquisition")
    public double getRunTemp(int cfgstate) {
        return this.RUN_TEMP[cfgstate];
    }

    @Override
    @Command(type=Command.CommandType.QUERY, description="Return the standard deviation of the temperature values")
    public double getTempStdDev() {
        int ntemp = 0;
        double tempsum = 0.0;
        double tempsqsum = 0.0;
        for (double tempval : this.tempDataMap.get(this.current_channel)) {
            tempsum += tempval;
            tempsqsum += tempval * tempval;
            ++ntemp;
        }
        double ovrstd = 0.0;
        if (ntemp > 0) {
            ovrstd = Math.sqrt(tempsqsum / (double)ntemp - tempsum * tempsum / (double)(ntemp * ntemp));
        }
        return ovrstd;
    }

    @Override
    @Command(type=Command.CommandType.QUERY, description="Return the temperature change over the sample period in degrees/minute")
    public double getTempChange() {
        double deltaTime;
        double slope = 0.0;
        List<Double> tempData = this.tempDataMap.get(this.current_channel);
        List<Double> tempTime = this.tempTimeMap.get(this.current_channel);
        if (tempData.size() > 1 && (deltaTime = tempTime.get(tempTime.size() - 1) - tempTime.get(0)) > 0.0) {
            slope = (tempData.get(tempData.size() - 1) - tempData.get(0)) / deltaTime;
        }
        return slope;
    }

    @Override
    @Command(type=Command.CommandType.QUERY, name="rampTemp", description="ramp the temperature to the desired point")
    public int rampTemp(@Argument(name="duration", description="number of seconds to ramp from current voltage to desired voltage") double duration, @Argument(name="value", description="Temp to ramp to") double value, @Argument(name="nsteps", description="number of steps") int nsteps) {
        try {
            double tnow = this.getTemp(this.current_channel);
            double tstep = (value - tnow) / (double)nsteps;
            int delta = (int)(1000.0 * duration / (double)nsteps);
            System.out.println("ramp T from " + Double.toString(tnow) + " C\n to " + Double.toString(value) + " C\n with delta Temp. (C) = " + Double.toString(tstep) + "\n and time step (ms) = " + Integer.toString(delta) + "\n Total duration (min) = " + duration / 60.0);
            System.out.println("starting temperature ramp ...");
            double t = tnow;
            boolean trip0 = this.isTrip();
            for (int istep = 0; istep < nsteps; ++istep) {
                System.out.println("Setting T = " + (t += tstep));
                if (!trip0 && this.isTrip()) {
                    this.log.error((Object)"STOPPING RAMP!!! IT LOOKS LIKE WE CAUSED A TRIP!");
                    this.clrTrip();
                    break;
                }
                this.setSetPoint(this.current_loop, t);
                try {
                    Thread.currentThread();
                    Thread.sleep(delta);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.log.info((Object)"temperature ramp completed");
        }
        catch (DriverException f) {
            this.log.error((Object)"Cryocon Device failed to ramp temperature!");
        }
        return 1;
    }

    @Override
    @Command(type=Command.CommandType.QUERY, name="rampTemp", description="ramp the temperature to the desired point")
    public int rampTemp(@Argument(name="duration", description="number of seconds to ramp from current voltage to desired voltage") double duration, @Argument(name="t_target", description="Temp to ramp to") double t_target, @Argument(name="nsteps", description="number of steps") int nsteps, @Argument(name="warmer_loop", description="number of steps") int iwloop, @Argument(name="other_loop", description="number of steps") int ioloop, @Argument(name="warm_temp_chan", description="number of steps") String wchan, @Argument(name="other_temp_chan", description="number of steps") String ochan, @Argument(name="delta_warm", description="Temp to ramp to") double delta_warm) {
        try {
            double t;
            double tnow = this.getTemp(wchan);
            double tstep = (t_target - tnow) / (double)nsteps;
            int delta = (int)(1000.0 * duration / (double)nsteps);
            System.out.println("ramp T from " + Double.toString(tnow) + " C\n to " + Double.toString(t_target) + " C\n with delta Temp. (C) = " + Double.toString(tstep) + "\n and time step (ms) = " + Integer.toString(delta) + "\n Total duration (min) = " + duration / 60.0);
            System.out.println("starting temperature ramp ...");
            double t_other = t = tnow;
            boolean trip0 = this.isTrip();
            double cryotol = this.cfg.getCryoTAcqTol();
            while (tstep > 0.0 && t < t_target - tstep || tstep < 0.0 && t > t_target + tstep || tstep > 0.0 && t_other < t_target - tstep || tstep < 0.0 && t_other > t_target + tstep) {
                if (tstep > 0.0 && t < t_target - tstep || tstep < 0.0 && t > t_target + tstep) {
                    t += tstep;
                    double otnow = this.getTemp(ochan);
                    if (t_other < t - delta_warm && otnow < tnow - delta_warm) {
                        t_other += tstep;
                    }
                } else if (tstep > 0.0 && t_other < t_target - tstep || tstep < 0.0 && t_other > t_target + tstep) {
                    t_other += tstep;
                }
                if (!trip0 && this.isTrip()) {
                    this.log.error((Object)"STOPPING RAMP!!! IT LOOKS LIKE WE CAUSED A TRIP!");
                    this.clrTrip();
                    break;
                }
                System.out.println("Setting warm loop temp to " + t + " C");
                this.setSetPoint(iwloop, t);
                System.out.println("Setting other loop temp to " + t_other + " C");
                this.setSetPoint(ioloop, t_other);
                try {
                    Thread.currentThread();
                    Thread.sleep(delta);
                }
                catch (Exception exception) {}
            }
            System.out.println("Setting warm loop temp to " + t + " C");
            this.setSetPoint(iwloop, t_target);
            System.out.println("Setting other loop temp to " + t_other + " C");
            this.setSetPoint(ioloop, t_target);
            this.log.info((Object)"temperature ramp completed");
        }
        catch (DriverException f) {
            this.log.error((Object)"Cryocon Device failed to ramp temperature!");
        }
        return 1;
    }

    @Override
    @Command(type=Command.CommandType.QUERY, name="getUnit", description="Retrieve temperature units")
    public char getUnit(@Argument(name="channel", description="Temp Channel to read") String channel) throws DriverException {
        return this.m24c.getUnit(channel.charAt(0));
    }

    @Override
    @Command(name="setUnit", description="Set temperature units")
    public void setUnit(@Argument(name="channel", description="Temp Channel to set") String channel, @Argument(name="units", description="Units in [K|C|F|S]") String unit) throws DriverException {
        this.m24c.setUnit(channel.charAt(0), unit.charAt(0));
    }

    @Command(name="getType", description="Get sensor type")
    public String getType(@Argument(name="channel", description="Temp Channel to set") String channel) throws DriverException {
        return this.m24c.getType(channel.charAt(0));
    }

    @Override
    @Command(name="setType", description="Set sensor type : DIODE|ACR|PTC100|PTC1K|NTC10UA|TC70|NONE")
    public void setType(@Argument(name="channel", description="Temp Channel to set") String channel, @Argument(name="type", description="Calib. curve type [DIODE|ACR|PTC100|PTC1K|NTC10UA|TC70|NONE]") String typ) throws DriverException {
        this.m24c.setType(channel.charAt(0), typ);
    }

    @Command(name="isOtdEnabled", description="Get whether OTD system enabled")
    public boolean isOtdEnabled() throws DriverException {
        return this.m24c.isOtdEnabled();
    }

    @Command(name="enableOtd", description="Set OTD system enabled state")
    public void enableOtd(@Argument(name="enab", description="Whether to enable OTD system") boolean enab) throws DriverException {
        this.m24c.enableOtd(enab);
    }

    @Command(name="getOtdSource", description="Get source channel for the OTD system")
    public char getOtdSource() throws DriverException {
        return this.m24c.getOtdSource();
    }

    @Command(name="setOtdSource", description="Set source channel for the OTD system")
    public void setOtdSource(@Argument(name="channel", description="channel [A-D]") String channel) throws DriverException {
        this.m24c.setOtdSource(channel.charAt(0));
    }

    @Command(name="getOtdTemp", description="Get temperature limit for the OTD system")
    public double getOtdTemp() throws DriverException {
        return this.m24c.getOtdTemp();
    }

    @Command(name="setOtdTemp", description="Set temperature limit for the OTD system")
    public void setOtdTemp(@Argument(name="temp", description="Temperature") double temp) throws DriverException {
        this.m24c.setOtdTemp(temp);
    }

    @Override
    @Command(name="setToControl", description="put loops in control mode")
    public void setToControl() throws DriverException {
        this.m24c.setToControl();
    }

    @Command(name="stopControl", description="Take loops out of control mode")
    public void stopControl() throws DriverException {
        this.m24c.stopControl();
    }

    @Override
    @Command(name="isInControl", description="is the CryoCon24c in control mode")
    public boolean isInControl() throws DriverException {
        return this.m24c.isInControl();
    }

    @Override
    @Command
    public int getState() {
        return this.cstate.ordinal();
    }

    @Override
    @Command
    public void setState(int istate) {
        this.cstate = TSState.cryostates.values()[istate];
    }

    @Override
    @Command
    public String getCurrent_channel() {
        return this.current_channel;
    }

    @Override
    @Command
    public String getCurrent_channel2() {
        return this.current_channel2;
    }

    @Override
    @Command
    public void setCurrent_channel(String current_channel) {
        this.current_channel = current_channel;
    }

    @Override
    @Command
    public void setCurrent_channel2(String current_channel2) {
        this.current_channel2 = current_channel2;
    }

    @Override
    @Command
    public int getCurrent_loop() {
        return this.current_loop;
    }

    @Override
    @Command
    public void setCurrent_loop(int current_loop) {
        this.current_loop = current_loop;
    }

    boolean isTrip() {
        return this.cstate == TSState.cryostates.TRIPPED;
    }

    boolean setTrip() {
        this.cstate = TSState.cryostates.TRIPPED;
        return false;
    }

    boolean clrTrip() {
        this.cstate = TSState.cryostates.OK;
        return false;
    }

    @Override
    public double get_init_temp(int cfgstate) {
        return this.RUN_TEMP[cfgstate];
    }

    static {
        channels.add("A");
        channels.add("B");
        channels.add("C");
        channels.add("D");
    }
}

