/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.doorman.main;

import java.io.Serializable;
import java.time.Instant;
import java.util.Collections;
import java.util.Map;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.data.KeyValueDataList;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

public final class TrendableRecord {
    private final String masterKey;
    private final Instant masterTimestamp;
    private final Map<String, Serializable> items;

    public TrendableRecord(String masterKey, Instant masterTimestamp, Map<String, Serializable> items) {
        this.masterKey = masterKey;
        this.masterTimestamp = masterTimestamp;
        this.items = Collections.unmodifiableMap(items);
    }

    public String getMasterKey() {
        return this.masterKey;
    }

    public Instant getMasterTimestamp() {
        return this.masterTimestamp;
    }

    public Map<String, Serializable> getItems() {
        return this.items;
    }

    public void post(Subsystem subsys) {
        KeyValueDataList kvdl = new KeyValueDataList(this.masterKey, CCSTimeStamp.currentTimeFromMillis((long)this.masterTimestamp.toEpochMilli()));
        this.items.forEach((key, value) -> kvdl.addData(key, value));
        subsys.publishSubsystemDataOnStatusBus((KeyValueData)kvdl);
    }

    public String toString() {
        StringBuilder repr = new StringBuilder();
        repr.append(String.format("Master key: %s%n", this.masterKey));
        repr.append(String.format("Master time: %s%n", this.masterTimestamp.toString()));
        this.items.forEach((key, value) -> repr.append(String.format("    %s: %s%n", key, value.toString())));
        return repr.toString();
    }
}

