/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.doorman.main;

import java.time.DateTimeException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.lsst.ccs.ComponentConfigurationEnvironment;
import org.lsst.ccs.ConfigurationService;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.subsystem.doorman.main.InstrumentConfig;
import org.lsst.ccs.subsystem.doorman.main.InstrumentType;
import org.lsst.ccs.subsystem.doorman.main.LocalConfigurationService;

public class CCSConfiguration
implements HasLifecycle,
LocalConfigurationService {
    @LookupField(strategy=LookupField.Strategy.TREE)
    private volatile ConfigurationService ccsConfig;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private volatile Subsystem subsys;
    private volatile Duration readoutInterval;
    private volatile List<InstrumentConfig> instConfigs;
    @ConfigurationParameter(name="readoutInterval", description="The time between readouts.")
    private volatile String readoutIntervalString = "PT1H";
    @ConfigurationParameter(description="Instrument make and/or model.")
    private volatile List<String> instrumentTypes = Collections.synchronizedList(new ArrayList());
    @ConfigurationParameter(description="Connection info for the instrument.")
    private volatile List<String> instrumentConnections = Collections.synchronizedList(new ArrayList());
    @ConfigurationParameter(description="The name or IPv4 address of the SMTP server.")
    private volatile String SMTPServer = "";
    @ConfigurationParameter(description="Email address, possibly fake, used as email sender.")
    private volatile String emailSender = "";
    @ConfigurationParameter(description="Real email address which receives bounced messages.")
    private volatile String emailBounceTo = "";
    @ConfigurationParameter(description="List of recipients of alarm emails.")
    private volatile String[] emailRecipients = new String[0];

    @Override
    public void makeConfigurationObjects() {
        ComponentConfigurationEnvironment configEnv = this.subsys.getComponentConfigurationEnvironment((Object)this);
        configEnv.printConfigurableParameters(new String[0]).forEach((key, value) -> System.out.println(key + " :: " + value));
        try {
            this.readoutInterval = Duration.parse(this.readoutIntervalString);
        }
        catch (DateTimeException exc) {
            throw new IllegalArgumentException("Bad configuration. Invalid readout interval.");
        }
        this.makeInstrumentConfigs();
    }

    @Override
    public List<InstrumentConfig> getInstrumentConfigs() {
        return this.instConfigs;
    }

    @Override
    public Duration getReadoutInterval() {
        return this.readoutInterval;
    }

    @Override
    public String getEmailSender() {
        return this.emailSender;
    }

    @Override
    public String getEmailBounceAddress() {
        return this.emailBounceTo;
    }

    @Override
    public String getSMTPServer() {
        return this.SMTPServer;
    }

    @Override
    public List<String> getEmailRecipients() {
        return Collections.unmodifiableList(Arrays.asList(this.emailRecipients));
    }

    private void makeInstrumentConfigs() {
        List<String> types = this.instrumentTypes;
        List<String> conns = this.instrumentConnections;
        if (types.size() != conns.size()) {
            throw new IllegalArgumentException("Bad configuration. Not all the instrumentXxx[] arrays are the same length.");
        }
        if (types.isEmpty()) {
            throw new IllegalArgumentException("Bad configuration. No instruments defined!");
        }
        CCSConfiguration.checkStringSet(types.stream(), Stream.of(InstrumentType.values()).map(InstrumentType::getConfigName), "Unknown instrument types");
        this.instConfigs = Collections.unmodifiableList(IntStream.range(0, types.size()).mapToObj(i -> new InstrumentConfig(i, InstrumentType.parse((String)types.get(i)).get(), (String)conns.get(i))).collect(Collectors.toList()));
    }

    private static void checkStringSet(Stream<String> mentioned, Stream<String> legal, String errorMsg) {
        Set unknown = mentioned.collect(Collectors.toSet());
        unknown.removeAll(legal.collect(Collectors.toSet()));
        if (unknown.size() > 0) {
            throw new IllegalArgumentException("Bad configuration. " + errorMsg + ": " + unknown.stream().collect(Collectors.joining(", ")));
        }
    }

    public void init() {
        ArrayList<String> missing = new ArrayList<String>();
        if (this.ccsConfig == null) {
            missing.add("CCS configuration service");
        }
        if (this.subsys == null) {
            missing.add("CCS Subsystem object");
        }
        if (!missing.isEmpty()) {
            throw new RuntimeException("Can't find " + String.join((CharSequence)", ", missing));
        }
    }
}

