/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.motorplatform.ts8;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.drivers.parker.AcrComm;
import org.lsst.ccs.drivers.parker.AxisBit;
import org.lsst.ccs.drivers.parker.AxisLong;
import org.lsst.ccs.drivers.parker.AxisName;
import org.lsst.ccs.drivers.parker.AxisSingle;
import org.lsst.ccs.drivers.parker.MasterBit;
import org.lsst.ccs.drivers.parker.MasterName;
import org.lsst.ccs.drivers.parker.ProgramName;
import org.lsst.ccs.drivers.parker.UserParameter;
import org.lsst.ccs.subsystem.motorplatform.bus.AxisStatus;
import org.lsst.ccs.subsystem.motorplatform.bus.MoveAxisAbsolute;
import org.lsst.ccs.subsystem.motorplatform.bus.MoveAxisRelative;
import org.lsst.ccs.subsystem.motorplatform.main.CheckException;

public class Axis {
    static final ProgramName moveProgram = ProgramName.PROG0;
    static final ProgramName homeProgram = ProgramName.PROG1;
    static final ProgramName errorProgram = ProgramName.PROG2;
    private String axisName;
    private AxisName enumName;
    private String units;
    @ConfigurationParameter(description="Maximum speed in mm/sec.")
    private volatile double maxSpeed = 10.0;
    @ConfigurationParameter(description="Longest possible move in mm.")
    private volatile double maxTravel = 600.0;
    @ConfigurationParameter(description="Speed in mm/sec for first leg of homing.")
    private volatile double fastHomingSpeed = this.maxSpeed;
    @ConfigurationParameter(description="Speed in mm/sec for second leg of homing.")
    private volatile double slowHomingSpeed = this.fastHomingSpeed / 10.0;
    @ConfigurationParameter(description="The size in mm of the 'triggered' zone of a limit switch.")
    private volatile double switchZoneLength = 10.0;
    private volatile boolean atHome = false;

    public String getName() {
        return this.axisName;
    }

    public AxisName getEnumName() {
        return this.enumName;
    }

    public String getUnits() {
        return this.units;
    }

    public boolean isAtHome() {
        return this.atHome;
    }

    public void setAtHome() {
        this.atHome = true;
    }

    public AxisStatus getStatus(AcrComm acr) {
        boolean enabled = acr.get(this.enumName, AxisBit.ENABLE_DRIVE);
        boolean moving = acr.get(this.enumName, AxisBit.JOG_ACTIVE);
        boolean atLow = acr.get(this.enumName, AxisBit.AT_NEGATIVE_HARD_LIMIT);
        boolean atHigh = acr.get(this.enumName, AxisBit.AT_POSITIVE_HARD_LIMIT);
        double ppu = acr.get(this.enumName, AxisSingle.PULSES_PER_UNIT);
        double position = (double)acr.get(this.enumName, AxisLong.PRIMARY_SETPOINT) / ppu;
        List<String> faults = this.getFaultList(acr);
        AxisStatus status = new AxisStatus(this.axisName, enabled, moving, this.atHome, atLow, atHigh, faults, position);
        return status;
    }

    private List<String> getFaultList(AcrComm acr) {
        ArrayList<String> faults = new ArrayList<String>();
        if (acr.get(this.enumName, AxisBit.HIT_NEGATIVE_HARD_LIMIT)) {
            faults.add("Hit low limit switch");
        }
        if (acr.get(this.enumName, AxisBit.HIT_POSITIVE_HARD_LIMIT)) {
            faults.add("Hit high limit switch");
        }
        if (acr.get(this.enumName, AxisBit.HIT_POSITIVE_SOFT_LIMIT)) {
            faults.add("At high soft limit");
        }
        if (acr.get(this.enumName, AxisBit.HIT_NEGATIVE_SOFT_LIMIT)) {
            faults.add("At low soft limit");
        }
        if (acr.get(this.enumName, AxisBit.KILL_ALL_MOTION)) {
            faults.add("Kill-motion request bit set");
        }
        if (acr.get(this.enumName, AxisBit.POSITIONING_ERROR)) {
            faults.add("Positioning error");
        }
        if (acr.get(this.enumName, AxisBit.DRIVE_FAULT)) {
            faults.add("Drive fault");
        }
        if (acr.get(MasterName.MASTER0, MasterBit.KILL_ALL_MOVES)) {
            faults.add("Master Kill Motion bit set");
        }
        return faults;
    }

    public void moveRelative(AcrComm acr, MoveAxisRelative cmd) {
        this.atHome = false;
        double d = cmd.getDistance();
        double t = (double)cmd.getTime().toMillis() / 1000.0;
        double v = Math.abs(d) / (t - 0.2);
        v = Math.min(v, this.maxSpeed);
        double a = 10.0 * v;
        double j = 0.0;
        acr.set(UserParameter.USER0, this.enumName.index());
        acr.set(UserParameter.USER1, d);
        acr.set(UserParameter.USER2, v);
        acr.set(UserParameter.USER3, a);
        acr.set(UserParameter.USER4, 0.0);
        acr.set(UserParameter.USER5, t + 1.0);
        acr.set(UserParameter.USER6, 0.0);
        acr.sendStr(String.format("RUN %s", moveProgram.reference()));
    }

    public Duration getRelativeMoveTimeout(MoveAxisRelative cmd) {
        double d = Math.abs(cmd.getDistance());
        double t = (double)cmd.getTime().toMillis() / 1000.0;
        double v = d / (t - 0.2);
        v = Math.min(v, this.maxSpeed);
        return Duration.ofMillis(Math.round(1000.0 * (d / v + 0.2)));
    }

    public void moveAbsolute(AcrComm acr, MoveAxisAbsolute cmd) {
        this.atHome = false;
        double d = Math.max(cmd.getPosition(), this.maxTravel - cmd.getPosition());
        double v = Math.min(cmd.getSpeed(), this.maxSpeed);
        double a = 10.0 * v;
        double j = 0.0;
        acr.set(UserParameter.USER0, this.enumName.index());
        acr.set(UserParameter.USER1, cmd.getPosition());
        acr.set(UserParameter.USER2, v);
        acr.set(UserParameter.USER3, a);
        acr.set(UserParameter.USER4, 0.0);
        acr.set(UserParameter.USER5, d / v + 1.0);
        acr.set(UserParameter.USER6, 1.0);
        acr.sendStr(String.format("RUN %s", moveProgram.reference()));
    }

    public Duration getAbsoluteMoveTimeout(MoveAxisAbsolute cmd) {
        double d = Math.max(cmd.getPosition(), this.maxTravel - cmd.getPosition());
        double v = Math.min(cmd.getSpeed(), this.maxSpeed);
        return Duration.ofMillis(Math.round(1000.0 * (d / v + 2.0)));
    }

    public int getMoveCompletionCode(AcrComm acr) {
        return (int)acr.get(UserParameter.USER0);
    }

    public void clearFaults(AcrComm acr) {
        acr.set(UserParameter.USER20, this.enumName.index());
        acr.sendStr(String.format("RUN %s", errorProgram.reference()));
    }

    public boolean hasFaults(AcrComm acr) {
        return !this.getFaultList(acr).isEmpty();
    }

    public Duration getHomingTimeout() {
        double t1 = this.maxTravel / this.fastHomingSpeed;
        double t2 = this.switchZoneLength / this.slowHomingSpeed;
        return Duration.ofMillis(Math.round(1000.0 * (t1 + t2 + 0.3)));
    }

    public int getHomingCompletionCode(AcrComm acr) {
        return (int)acr.get(UserParameter.USER10);
    }

    public void home(AcrComm acr) {
        this.atHome = false;
        acr.set(UserParameter.USER10, this.enumName.index());
        acr.set(UserParameter.USER11, this.fastHomingSpeed);
        acr.set(UserParameter.USER12, this.slowHomingSpeed);
        acr.set(UserParameter.USER13, 10.0 * this.fastHomingSpeed);
        acr.set(UserParameter.USER14, this.maxTravel / this.fastHomingSpeed);
        acr.set(UserParameter.USER15, this.switchZoneLength / this.slowHomingSpeed);
        acr.sendStr(String.format("RUN %s", homeProgram.reference()));
    }

    public void enable(AcrComm acr) {
        acr.set(this.enumName, AxisBit.ENABLE_DRIVE, true);
        boolean isEnabled = acr.get(this.enumName, AxisBit.ENABLE_DRIVE);
        if (!isEnabled) {
            throw new CheckException("EN FAIL", String.format("Enable of %s axis failed.", this.axisName));
        }
    }

    public void disable(AcrComm acr) {
        this.atHome = false;
        acr.set(this.enumName, AxisBit.ENABLE_DRIVE, false);
        boolean isEnabled = acr.get(this.enumName, AxisBit.ENABLE_DRIVE);
        if (isEnabled) {
            throw new CheckException("DIS FAIL", String.format("Disable of %s axis failed.", this.axisName));
        }
    }
}

