/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.bk;

import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.lsst.ccs.drivers.ascii.Ascii;
import org.lsst.ccs.drivers.commons.DriverConstants;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.commons.PowerSupplyDriver;

public class Model1696
extends Ascii
implements PowerSupplyDriver {
    public static final int DEFAULT_BAUDRATE = 9600;
    private final Timer timer = new Timer("Timer_1696", true);
    private long onDelay = 0L;
    private long offDelay = 0L;
    private SetOutput outTask;
    private static final Map<String, Integer> lcdMap = new HashMap<String, Integer>();

    public Model1696() {
        this.setOptions(Ascii.Option.NO_NET);
        this.setDefaultParm(9600);
    }

    public void open(DriverConstants.ConnType connType, String ident, int baudRate, int commParm) throws DriverException {
        super.open(connType, ident, baudRate, commParm);
        this.setTerminator(Ascii.Terminator.CR);
        try {
            this.getVoltage(0);
        }
        catch (DriverException e) {
            this.closeSilent();
            throw e;
        }
    }

    public void setOutput(boolean on, int chan) throws DriverException {
        long delay = on ? this.onDelay : this.offDelay;
        String command = "SOUT" + this.chanString(chan) + (on ? "0" : "1");
        SetOutput task = this.outTask;
        if (task != null) {
            task.cancel();
            this.outTask = null;
        }
        if (delay == 0L) {
            this.writeCmnd(command);
        } else {
            this.outTask = new SetOutput(command);
            this.timer.schedule((TimerTask)this.outTask, delay);
        }
    }

    public boolean getOutput(int chan) throws DriverException {
        return this.getPanel((int)chan).onDisplay;
    }

    public void setOnDelay(double time, int chan) throws DriverException {
        this.onDelay = (long)(1000.0 * time);
    }

    public void setOffDelay(double time, int chan) throws DriverException {
        this.offDelay = (long)(1000.0 * time);
    }

    public void setVoltage(double value, int chan) throws DriverException {
        this.writeCmnd("VOLT" + this.chanString(chan) + this.valString(value, 10.0));
    }

    public double getVoltage(int chan) throws DriverException {
        String reply = this.readCmnd("GETS" + this.chanString(chan));
        return Double.valueOf(reply.substring(0, 3)) / 10.0;
    }

    public double readVoltage(int chan) throws DriverException {
        String reply = this.readCmnd("GETD" + this.chanString(chan));
        return Double.valueOf(reply.substring(0, 4)) / 100.0;
    }

    public void setCurrent(double value, int chan) throws DriverException {
        this.writeCmnd("CURR" + this.chanString(chan) + this.valString(value, 100.0));
    }

    public double getCurrent(int chan) throws DriverException {
        String reply = this.readCmnd("GETS" + this.chanString(chan));
        return Double.valueOf(reply.substring(3, 6)) / 100.0;
    }

    public double readCurrent(int chan) throws DriverException {
        String reply = this.readCmnd("GETD" + this.chanString(chan));
        return Double.valueOf(reply.substring(4, 8)) / 1000.0;
    }

    public void setVoltageLimit(double value, int chan) throws DriverException {
        this.writeCmnd("SOVP" + this.chanString(chan) + this.valString(value, 10.0));
    }

    public double getVoltageLimit(int chan) throws DriverException {
        return Double.valueOf(this.readCmnd("GOVP" + this.chanString(chan))) / 10.0;
    }

    public void lockPanel(boolean lock, int chan) throws DriverException {
        this.writeCmnd((lock ? "SESS" : "ENDS") + this.chanString(chan));
    }

    public boolean isPanelLocked(int chan) throws DriverException {
        return this.getPanel((int)chan).lockDisplay;
    }

    public Panel getPanel(int chan) throws DriverException {
        String reply = this.readCmnd("GPAL" + this.chanString(chan));
        Panel data = new Panel();
        data.timerDisplay = this.getLcdBoolean(reply, 36);
        data.colonDisplay = this.getLcdBoolean(reply, 37);
        data.vConstDisplay = this.getLcdBoolean(reply, 46);
        data.vSetDisplay = this.getLcdBoolean(reply, 47);
        data.iConstDisplay = this.getLcdBoolean(reply, 55);
        data.iSetDisplay = this.getLcdBoolean(reply, 56);
        data.programDisplay = this.getLcdBoolean(reply, 60);
        data.settingDisplay = this.getLcdBoolean(reply, 62);
        data.lockDisplay = this.getLcdBoolean(reply, 63);
        data.unlockDisplay = this.getLcdBoolean(reply, 64);
        data.faultDisplay = this.getLcdBoolean(reply, 65);
        data.onDisplay = this.getLcdBoolean(reply, 66);
        data.offDisplay = this.getLcdBoolean(reply, 67);
        data.remoteDisplay = this.getLcdBoolean(reply, 68);
        data.readVoltage = this.getLcdValue(reply, 1, 4);
        data.readCurrent = this.getLcdValue(reply, 10, 4);
        data.readPower = this.getLcdValue(reply, 19, 4);
        data.setVoltage = this.getLcdValue(reply, 40, 3);
        data.setCurrent = this.getLcdValue(reply, 49, 3);
        data.minutes = (int)this.getLcdValue(reply, 28, 2);
        data.seconds = (int)this.getLcdValue(reply, 30, 2);
        data.program = (int)this.getLcdValue(reply, 58, 1);
        return data;
    }

    private synchronized void writeCmnd(String instr) throws DriverException {
        this.write(instr);
        String ack = this.read();
        if (!ack.equals("OK")) {
            throw new DriverException("Unrecognized command response (" + ack + ")");
        }
    }

    private synchronized String readCmnd(String instr) throws DriverException {
        this.write(instr);
        String reply = this.read();
        String ack = this.read();
        if (!ack.equals("OK")) {
            throw new DriverException("Unrecognized command response (" + ack + ")");
        }
        return reply;
    }

    private String chanString(int chan) throws DriverException {
        String str = String.format("%02d", chan);
        if (str.length() != 2) {
            throw new DriverException("Invalid channel number (" + chan + ")");
        }
        return str;
    }

    private String valString(double value, double mult) throws DriverException {
        int ival = (int)(mult * value + 0.5);
        String str = String.format("%03d", ival);
        if (str.length() != 3) {
            throw new DriverException("Invalid value (" + value + ")");
        }
        return str;
    }

    private boolean getLcdBoolean(String data, int index) {
        return data.substring(index - 1, index).equals("0");
    }

    private double getLcdValue(String data, int index, int leng) throws DriverException {
        double value = 0.0;
        double div = 1.0;
        int point = leng;
        --index;
        int j = 0;
        while (j < leng) {
            Integer digit = lcdMap.get(data.substring(index, index + 2));
            if (digit == null) {
                throw new DriverException("Invalid LCD string");
            }
            if (digit > 9) {
                digit = digit - 10;
                point = j + 1;
            }
            value = 10.0 * value + (double)digit.intValue();
            ++j;
            index += 2;
        }
        for (j = 0; j < leng - point; ++j) {
            div *= 10.0;
        }
        return value / div;
    }

    static {
        lcdMap.put("00", 0);
        lcdMap.put("3?", 0);
        lcdMap.put("06", 1);
        lcdMap.put("5;", 2);
        lcdMap.put("4?", 3);
        lcdMap.put("66", 4);
        lcdMap.put("6=", 5);
        lcdMap.put("7=", 6);
        lcdMap.put("07", 7);
        lcdMap.put("7?", 8);
        lcdMap.put("6?", 9);
        lcdMap.put("80", 10);
        lcdMap.put(";?", 10);
        lcdMap.put("86", 11);
        lcdMap.put("=;", 12);
        lcdMap.put("<?", 13);
        lcdMap.put(">6", 14);
        lcdMap.put(">=", 15);
        lcdMap.put("?=", 16);
        lcdMap.put("87", 17);
        lcdMap.put("??", 18);
        lcdMap.put(">?", 19);
    }

    class SetOutput
    extends TimerTask {
        private final String command;

        SetOutput(String command) {
            this.command = command;
        }

        @Override
        public void run() {
            try {
                Model1696.this.writeCmnd(this.command);
            }
            catch (DriverException driverException) {
                // empty catch block
            }
            Model1696.this.outTask = null;
        }
    }

    public static class Panel {
        public boolean timerDisplay;
        public boolean colonDisplay;
        public boolean vConstDisplay;
        public boolean vSetDisplay;
        public boolean iConstDisplay;
        public boolean iSetDisplay;
        public boolean programDisplay;
        public boolean settingDisplay;
        public boolean lockDisplay;
        public boolean unlockDisplay;
        public boolean faultDisplay;
        public boolean onDisplay;
        public boolean offDisplay;
        public boolean remoteDisplay;
        public double readVoltage;
        public double readCurrent;
        public double readPower;
        public double setVoltage;
        public double setCurrent;
        public int minutes;
        public int seconds;
        public int program;
    }
}

