/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shutter.statemachine;

import java.util.logging.Logger;
import org.lsst.ccs.subsystem.shutter.common.PhysicalState;
import org.lsst.ccs.subsystem.shutter.common.SoftwareState;
import org.lsst.ccs.subsystem.shutter.statemachine.Actions;
import org.lsst.ccs.subsystem.shutter.statemachine.Channel;
import org.lsst.ccs.subsystem.shutter.statemachine.EventReply;
import org.lsst.ccs.subsystem.shutter.statemachine.Logging;
import org.lsst.ccs.subsystem.shutter.statemachine.PromptReply;
import org.lsst.ccs.subsystem.shutter.statemachine.SimpleState;
import org.lsst.ccs.subsystem.shutter.statemachine.TopContext;

class SyncError
extends SimpleState<TopContext> {
    private static final Logger LOG = Logger.getLogger(SyncError.class.getName());

    public SyncError(TopContext context) {
        super(context);
    }

    @Override
    public Logger getLogger() {
        return LOG;
    }

    @Override
    public void entry() {
        Logging.logEntry(this);
        ((TopContext)this.getContext()).getActions().setSoftwareState(SoftwareState.SYNC_ERROR);
        ((TopContext)this.getContext()).getActions().terminateContact();
        ((TopContext)this.getContext()).getActions().raiseSyncAlert();
        ((TopContext)this.getContext()).getActions().setPhysicalState(PhysicalState.OTHER);
    }

    @Override
    public void resync(Channel<EventReply> chan) throws InterruptedException {
        Logging.logEvent(this);
        chan.write(PromptReply.ACCEPTED);
        Actions act = ((TopContext)this.getContext()).getActions();
        ((TopContext)this.getContext()).makeTransition(((TopContext)this.getContext()).getSynchronizingState(), () -> {
            act.lowerMotionAlert();
            act.lowerPLCAlert();
            act.lowerWatchdogAlert();
        });
    }
}

