/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shutter.statemachine;

import java.time.Duration;
import java.util.Objects;
import org.lsst.ccs.subsystem.shutter.statemachine.EventReply;

final class PromptReply
implements EventReply {
    public static final PromptReply ACCEPTED = new PromptReply();
    private final String msg;
    private final boolean accepted;
    private volatile boolean waited;

    private PromptReply() {
        this.accepted = true;
        this.msg = "ACCEPTED";
        this.waited = false;
    }

    public PromptReply(String msg) {
        this.accepted = false;
        this.msg = Objects.requireNonNull(msg, "Argument must not be null.");
        this.waited = false;
    }

    @Override
    public boolean wasAccepted(Duration timeout) {
        this.waited = true;
        return this.accepted;
    }

    @Override
    public String getMessage() {
        if (!this.waited) {
            throw new IllegalStateException("Didn't wait for completion with wasAccepted().");
        }
        return this.msg;
    }

    public String toString() {
        return "PromptReply{" + this.msg + '}';
    }
}

