/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.subsystems.fcs.Carousel;
import org.lsst.ccs.subsystems.fcs.CarouselClamp;
import org.lsst.ccs.subsystems.fcs.EPOSEnumerations;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.errors.FailedCommandException;
import org.lsst.ccs.subsystems.fcs.errors.RejectedCommandException;
import org.lsst.ccs.subsystems.fcs.simulation.SimuEPOSController;
import org.lsst.ccs.subsystems.fcs.simulation.SimuTTC580;

public class SimuCarouselClampController
extends SimuEPOSController {
    @LookupField(strategy=LookupField.Strategy.TREE, pathFilter=".*carousel")
    protected Carousel carousel;
    @LookupField(strategy=LookupField.Strategy.TREE, pathFilter=".*hyttc580")
    private SimuTTC580 hyttc580;

    public SimuCarouselClampController(int nodeID, String serialNB) {
        super(nodeID, serialNB);
    }

    public void init() {
        this.mode = EPOSEnumerations.EposMode.CURRENT;
    }

    @Override
    public void writeCurrent(int currentValue) {
        CarouselClamp clamp;
        FCSCst.FCSLOG.debug((Object)(this.getName() + "==========> ACTUATOR ON"));
        if (this.carousel.getSocketAtStandby() == null) {
            throw new RejectedCommandException(this.getName() + " can't writeCurrent to clamp controller when there is no socket at standby position");
        }
        if (this.name.contains("Xminus")) {
            clamp = this.carousel.getSocketAtStandby().getClampXminus();
        } else if (this.name.contains("Xplus")) {
            clamp = this.carousel.getSocketAtStandby().getClampXplus();
        } else {
            throw new RejectedCommandException(this.name + ":couldn't find the clamp to unlock");
        }
        boolean atStandby = true;
        this.hyttc580.simulateClampIsUnlocked(atStandby, clamp);
        this.carousel.updateStateWithSensors();
        this.publishData();
    }

    @Override
    public void stopAction() {
        CarouselClamp clamp;
        FCSCst.FCSLOG.debug((Object)(this.name + "==========> ACTUATOR OFF"));
        if (this.name.contains("Xminus")) {
            clamp = this.carousel.getClampXminus();
        } else if (this.name.contains("Xplus")) {
            clamp = this.carousel.getClampXplus();
        } else {
            throw new FailedCommandException(this.name + ": unable to find the clamp to unlock.");
        }
        clamp.updateState();
        this.publishData();
    }
}

