/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.daq.ims;

import java.io.Serializable;
import java.time.Instant;
import java.util.BitSet;
import java.util.Collections;
import java.util.Set;
import org.lsst.ccs.daq.ims.Version;
import org.lsst.ccs.utilities.location.Location;
import org.lsst.ccs.utilities.location.LocationSet;

public class ImageMetaData
implements Serializable {
    private static final long serialVersionUID = 6128502939552309548L;
    private final String name;
    private final String annotation;
    private final Version release;
    private final int opcode;
    private final Instant timestamp;
    private final LocationSet elements;
    private final long id;
    private final String creationFolder;

    ImageMetaData(long id, String name, String folderName, String annotation, Version release, int opcode, long timestampNanos, BitSet elements) {
        this.id = id;
        this.name = name;
        this.annotation = annotation;
        this.release = release;
        this.opcode = opcode;
        this.timestamp = Instant.ofEpochSecond(timestampNanos / 1000000000L, timestampNanos % 1000000000L);
        this.elements = new LocationSet(elements);
        this.creationFolder = folderName;
    }

    ImageMetaData(long id, Version release, Instant timestamp, ImageMetaData meta) {
        this.id = id;
        this.timestamp = timestamp;
        this.release = release;
        this.annotation = meta.annotation;
        this.creationFolder = meta.creationFolder;
        this.elements = meta.elements;
        this.opcode = meta.opcode;
        this.name = meta.name;
    }

    public ImageMetaData(String imageName, String creationFolder, String annotation, int opcode, Set<Location> locationSet) {
        this.name = imageName;
        this.creationFolder = creationFolder;
        this.annotation = annotation;
        this.release = null;
        this.opcode = opcode;
        this.elements = new LocationSet(locationSet);
        this.timestamp = Instant.EPOCH;
        this.id = 0L;
    }

    public String getName() {
        return this.name;
    }

    public String getAnnotation() {
        return this.annotation;
    }

    public Version getRelease() {
        return this.release;
    }

    public int getOpcode() {
        return this.opcode;
    }

    public Instant getTimestamp() {
        return this.timestamp;
    }

    public Set<Location> getLocations() {
        return Collections.unmodifiableSet(this.elements);
    }

    public long getId() {
        return this.id;
    }

    public String getCreationFolderName() {
        return this.creationFolder;
    }

    BitSet getLocationBitSet() {
        return this.elements.getBitSet();
    }

    public String toString() {
        return "ImageMetaData{name=" + this.name + ", annotation=" + this.annotation + ", release=" + this.release + ", opcode=" + this.opcode + ", timestamp=" + this.timestamp + ", elements=" + this.elements + ", id=" + this.id + ", creationFolder=" + this.creationFolder + '}';
    }
}

