/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.ui.commons;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JFrame;
import org.lsst.ccs.subsystems.fcs.ui.commons.Tools;

public class RectangleSwitch
extends JComponent {
    private String sensorName;
    private int width = 60;
    private int height = this.width * 4 / 5;
    private Color color = new Color(0, 153, 0);

    public RectangleSwitch() {
        super.setPreferredSize(new Dimension(this.width, this.height));
    }

    public RectangleSwitch(String sensorName) {
        super.setPreferredSize(new Dimension(this.width, this.height));
        this.sensorName = sensorName;
    }

    public void setWidth(int width) {
        this.width = width;
        this.height = width * 4 / 5;
        super.setPreferredSize(new Dimension(width, this.height));
        this.repaint();
    }

    public void setColor(Color c) {
        this.color = c;
        this.repaint();
    }

    public void updateColor(boolean sensorInError, boolean sensorValue) {
        if (sensorInError) {
            this.setColor(Color.RED);
        } else {
            this.setColor(sensorValue ? Tools.greenColor : Color.gray);
        }
    }

    public void updateColorGreenGray(Map<String, Serializable> sMap) {
        if (sMap.containsKey(this.sensorName)) {
            this.setColor(1 == (Integer)sMap.get(this.sensorName) ? Color.GREEN : Color.gray);
        }
    }

    public void updateColorGrayGreen(Map<String, Serializable> sMap) {
        if (sMap.containsKey(this.sensorName)) {
            this.setColor(1 == (Integer)sMap.get(this.sensorName) ? Color.gray : Color.GREEN);
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g.create();
        Rectangle r = new Rectangle(0, 0, this.width, this.height);
        g2d.setColor(this.color);
        g2d.fill(r);
        g2d.setColor(Color.BLACK);
        g2d.draw(r);
        g2d.dispose();
    }

    public static void main(String[] argv) {
        RectangleSwitch d = new RectangleSwitch();
        JFrame frame = new JFrame("Test");
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
    }
}

