/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.ui.commons;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByEPOSController;
import org.lsst.ccs.subsystems.fcs.ui.commons.DigitalSwitch;
import org.lsst.ccs.subsystems.fcs.ui.commons.Tools;

public class ControllerStatePanel
extends JPanel {
    private static final Logger FCSLOG = Logger.getLogger(ControllerStatePanel.class.getName());
    private final int WIDTH = 180;
    private final int HEIGHT = 250;
    private final String controllerName;
    private final DigitalSwitch controllerSwitch = new DigitalSwitch();
    private final JLabel eposStateLabel = new JLabel();
    private final JLabel modeLabel = new JLabel();
    private final JLabel currentjLabel = new JLabel("0");
    private final JLabel positionjLabel = new JLabel("0");
    private final JLabel velocityjLabel = new JLabel("0");
    private boolean displayPosition = true;

    public ControllerStatePanel(String ctlName, boolean displayPosition) {
        this.controllerName = ctlName;
        this.displayPosition = displayPosition;
        this.initComponents();
    }

    public void update(StatusDataPublishedByEPOSController s) {
        FCSLOG.fine(() -> "ControllerStatePanel updating from controller data of " + this.controllerName);
        SwingUtilities.invokeLater(new UpdateController(s));
    }

    private void initComponents() {
        this.setDefaultValues();
        this.setBorder(BorderFactory.createTitledBorder(this.controllerName));
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(new Dimension(180, 250));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = Tools.insets_std;
        gbc.anchor = 10;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        this.controllerSwitch.setSize(40);
        this.add((Component)this.controllerSwitch, gbc);
        ++gbc.gridy;
        this.add((Component)this.eposStateLabel, gbc);
        ++gbc.gridy;
        this.add((Component)this.modeLabel, gbc);
        gbc.anchor = 17;
        gbc.gridwidth = 1;
        gbc.gridy = 4;
        this.add((Component)new JLabel("<HTML>Current : <BR>(in mA) </HTML>"), gbc);
        ++gbc.gridy;
        this.add((Component)new JLabel("<HTML>Velocity : <BR>(in rpm) </HTML>"), gbc);
        if (this.displayPosition) {
            ++gbc.gridy;
            this.add((Component)new JLabel("<HTML>Position : <BR>(in um)</HTML>"), gbc);
        }
        ++gbc.gridx;
        gbc.gridy = 4;
        gbc.anchor = 13;
        this.add((Component)this.currentjLabel, gbc);
        ++gbc.gridy;
        this.add((Component)this.velocityjLabel, gbc);
        if (this.displayPosition) {
            ++gbc.gridy;
            this.add((Component)this.positionjLabel, gbc);
        }
    }

    private void setDefaultValues() {
        this.controllerSwitch.setColor(Color.gray);
        this.eposStateLabel.setText("UNKNOWN STATE");
        this.modeLabel.setText("UNKNOWN");
        this.positionjLabel.setText("0");
        this.currentjLabel.setText("0");
        this.velocityjLabel.setText("0");
    }

    public void resetPanel() {
        this.setDefaultValues();
    }

    @Override
    public String toString() {
        return "Controller State View";
    }

    public static void main(String[] argv) {
        ControllerStatePanel d = new ControllerStatePanel("controller", true);
        JFrame frame = new JFrame("Test");
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
    }

    public class UpdateController
    implements Runnable {
        private final StatusDataPublishedByEPOSController s;

        private UpdateController(StatusDataPublishedByEPOSController s) {
            this.s = s;
        }

        @Override
        public void run() {
            if (this.s.isBooted() && this.s.getState() != null) {
                ControllerStatePanel.this.eposStateLabel.setText(this.s.getState().name());
                ControllerStatePanel.this.controllerSwitch.setColor(this.s.getState().getColor());
            } else if (!this.s.isBooted()) {
                ControllerStatePanel.this.eposStateLabel.setText("not booted");
                ControllerStatePanel.this.controllerSwitch.setColor(Color.RED);
            }
            if (this.s.isBooted()) {
                if (ControllerStatePanel.this.displayPosition) {
                    ControllerStatePanel.this.positionjLabel.setText(Integer.toString(this.s.getPosition()));
                }
                ControllerStatePanel.this.currentjLabel.setText(Integer.toString(this.s.getCurrent()));
                ControllerStatePanel.this.velocityjLabel.setText(Integer.toString(this.s.getVelocity()));
            }
            ControllerStatePanel.this.modeLabel.setText(this.s.getMode() == null ? "UNKNOWN" : this.s.getMode().toString());
        }
    }
}

