/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.text.DecimalFormat;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerSeneca;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByCarouselBrakes;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByHYTTC580TemperaturesDevices;
import org.lsst.ccs.subsystems.fcs.ui.commons.Tools;

public class TemperaturesViewPanel
extends JPanel {
    private static final int tempCol = 1;
    private static final int noOfSockets = 5;
    private static final int noOfAutochangerTemperatures = 8;
    private final String title = "Temperatures Overview";
    private final DecimalFormat formatter = new DecimalFormat("#####0.00");
    private DefaultTableModel caTableModel;
    private DefaultTableModel acTableModel;

    public TemperaturesViewPanel() {
        this.initComponents();
    }

    @Override
    public String toString() {
        return "Temperatures Overview";
    }

    private void initComponents() {
        Vector<String> columnNames = new Vector<String>(){
            {
                this.add("Name");
                this.add("Temperature (\u00b0C)");
            }
        };
        this.caTableModel = new DefaultTableModel(columnNames, 0);
        JTable caTempTable = new JTable(this.caTableModel);
        this.initCarouselTable();
        this.acTableModel = new DefaultTableModel(columnNames, 0);
        JTable acTempTable = new JTable(this.acTableModel);
        this.initAutochangerTable();
        this.setBorder(Tools.getGeneralPanelTitle("Temperatures Overview"));
        JScrollPane scrollPane1 = new JScrollPane(caTempTable);
        scrollPane1.setBorder(BorderFactory.createTitledBorder("Carousel temperature sensors"));
        scrollPane1.setPreferredSize(new Dimension(600, 250));
        JScrollPane scrollPane2 = new JScrollPane(acTempTable);
        scrollPane2.setBorder(BorderFactory.createTitledBorder("Autochanger temperature sensors"));
        scrollPane2.setPreferredSize(new Dimension(600, 200));
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)scrollPane1, "North");
        panel.add((Component)scrollPane2, "Center");
        this.add(panel);
    }

    private void initCarouselTable() {
        this.caTableModel.addRow(new Object[]{"Motor in Bay D", ""});
        this.caTableModel.addRow(new Object[]{"Brake in Bay I", ""});
        this.caTableModel.addRow(new Object[]{"Brake in Bay N", ""});
        this.caTableModel.addRow(new Object[]{"Brake in Bay X", ""});
        this.caTableModel.addRow(new Object[]{"Clamps (average)", ""});
        this.caTableModel.addRow(new Object[]{"TTC580", ""});
        for (int i = 1; i <= 5; ++i) {
            this.caTableModel.addRow(new Object[]{"Socket " + i, ""});
        }
        this.caTableModel.fireTableDataChanged();
    }

    private void initAutochangerTable() {
        for (StatusDataPublishedByAutochangerSeneca.TempId tempId : StatusDataPublishedByAutochangerSeneca.TempId.values()) {
            this.acTableModel.addRow(new Object[]{tempId.getDescription(), ""});
        }
        this.acTableModel.fireTableDataChanged();
    }

    protected void updateFromStatusData(KeyValueData data) {
        SwingUtilities.invokeLater(new Update(data));
    }

    public class Update
    implements Runnable {
        private final KeyValueData data;

        public Update(KeyValueData data) {
            this.data = data;
        }

        @Override
        public void run() {
            Class<?> actualClass = this.data.getValue().getClass();
            switch (actualClass.getSimpleName()) {
                case "StatusDataPublishedByCarouselBrakes": {
                    this.updateCarouselBrakes((StatusDataPublishedByCarouselBrakes)this.data.getValue());
                    break;
                }
                case "StatusDataPublishedByHYTTC580TemperaturesDevices": {
                    this.updateTTC580Temperatures((StatusDataPublishedByHYTTC580TemperaturesDevices)this.data.getValue());
                    break;
                }
                case "StatusDataPublishedByAutochangerSeneca": {
                    this.updateAutochangerTemperatures((StatusDataPublishedByAutochangerSeneca)this.data.getValue());
                    break;
                }
            }
        }

        private void updateCarouselBrakes(StatusDataPublishedByCarouselBrakes s) {
            TemperaturesViewPanel.this.caTableModel.setValueAt(TemperaturesViewPanel.this.formatter.format(s.getTemperature1()), carouselRow.BayD.ordinal(), 1);
            TemperaturesViewPanel.this.caTableModel.setValueAt(TemperaturesViewPanel.this.formatter.format(s.getTemperature2()), carouselRow.BayI.ordinal(), 1);
            TemperaturesViewPanel.this.caTableModel.setValueAt(TemperaturesViewPanel.this.formatter.format(s.getTemperature3()), carouselRow.BayN.ordinal(), 1);
            TemperaturesViewPanel.this.caTableModel.setValueAt(TemperaturesViewPanel.this.formatter.format(s.getTemperature4()), carouselRow.BayX.ordinal(), 1);
            TemperaturesViewPanel.this.caTableModel.fireTableDataChanged();
        }

        private void updateTTC580Temperatures(StatusDataPublishedByHYTTC580TemperaturesDevices s) {
            for (int i = 0; i < 5; ++i) {
                TemperaturesViewPanel.this.caTableModel.setValueAt(TemperaturesViewPanel.this.formatter.format(s.getSocketTemperature(i + 1)), carouselRow.Socket1.ordinal() + i, 1);
            }
            TemperaturesViewPanel.this.caTableModel.setValueAt(TemperaturesViewPanel.this.formatter.format(s.getAverageClampsTemperature()), carouselRow.AverageClamps.ordinal(), 1);
            TemperaturesViewPanel.this.caTableModel.setValueAt(TemperaturesViewPanel.this.formatter.format(s.getInternalTemperature()), carouselRow.TTC580.ordinal(), 1);
            TemperaturesViewPanel.this.caTableModel.fireTableDataChanged();
        }

        private void updateAutochangerTemperatures(StatusDataPublishedByAutochangerSeneca s) {
            for (int i = 0; i < 8; ++i) {
                TemperaturesViewPanel.this.acTableModel.setValueAt(TemperaturesViewPanel.this.formatter.format(s.getTemperature(i)), StatusDataPublishedByAutochangerSeneca.TempId.LINEAR_RAIL_MOTOR_X_PLUS.ordinal() + i, 1);
            }
            TemperaturesViewPanel.this.acTableModel.fireTableDataChanged();
        }
    }

    private static enum carouselRow {
        BayD,
        BayI,
        BayN,
        BayX,
        AverageClamps,
        TTC580,
        Socket1;

    }
}

