/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.parker;

import org.lsst.ccs.drivers.parker.AxisName;
import org.lsst.ccs.drivers.parker.AxisUnsigned;

public enum AxisBit {
    CAPTURE_COMPLETE(777, 32, AxisUnsigned.PRIMARY_AXIS_FLAGS, 9),
    JOG_ACTIVE(792, 32, AxisUnsigned.PRIMARY_AXIS_FLAGS, 24),
    KILL_ALL_MOTION(8467, 32, AxisUnsigned.QUATERNARY_AXIS_FLAGS, 19),
    POSITIONING_ERROR(8479, 32, AxisUnsigned.QUATERNARY_AXIS_FLAGS, 31),
    HIT_POSITIVE_HARD_LIMIT(16132, 32, AxisUnsigned.QUINARY_AXIS_FLAGS, 4),
    HIT_NEGATIVE_HARD_LIMIT(16133, 32, AxisUnsigned.QUINARY_AXIS_FLAGS, 5),
    HIT_POSITIVE_SOFT_LIMIT(16140, 32, AxisUnsigned.QUINARY_AXIS_FLAGS, 8),
    HIT_NEGATIVE_SOFT_LIMIT(16141, 32, AxisUnsigned.QUINARY_AXIS_FLAGS, 9),
    HOME_FOUND(16134, 32, AxisUnsigned.QUINARY_AXIS_FLAGS, 6),
    HOME_NOT_FOUND(16135, 32, AxisUnsigned.QUINARY_AXIS_FLAGS, 7),
    INVERT_POSITIVE_HARD_LIMIT_SIGNAL(16144, 32, AxisUnsigned.QUINARY_AXIS_FLAGS, 16),
    INVERT_NEGATIVE_HARD_LIMIT_SIGNAL(16145, 32, AxisUnsigned.QUINARY_AXIS_FLAGS, 17),
    INVERT_HOME_REGION_SIGNAL(16146, 32, AxisUnsigned.QUINARY_AXIS_FLAGS, 18),
    ENABLE_POSITIVE_HARD_LIMIT(16148, 32, AxisUnsigned.QUINARY_AXIS_FLAGS, 20),
    ENABLE_NEGATIVE_HARD_LIMIT(16149, 32, AxisUnsigned.QUINARY_AXIS_FLAGS, 21),
    ENABLE_POSITIVE_SOFT_LIMIT(16150, 32, AxisUnsigned.QUINARY_AXIS_FLAGS, 22),
    ENABLE_NEGATIVE_SOFT_LIMIT(16151, 32, AxisUnsigned.QUINARY_AXIS_FLAGS, 23),
    HOMING_USE_BACKUP(16152, 32, AxisUnsigned.QUINARY_AXIS_FLAGS, 24),
    HOMING_SEEK_NEGATIVE_EDGE(16153, 32, AxisUnsigned.QUINARY_AXIS_FLAGS, 25),
    HOMING_NEGATIVE_FINAL_APPROACH(16154, 32, AxisUnsigned.QUINARY_AXIS_FLAGS, 26);

    private final int base;
    private final int step;
    private final AxisUnsigned flagParameter;
    private final long bitMask;

    private AxisBit(int base, int step, AxisUnsigned flagParameter, int bitIndex) {
        this.base = base;
        this.step = step;
        this.flagParameter = flagParameter;
        this.bitMask = 1L << bitIndex;
    }

    public int index(AxisName axis) {
        return this.base + axis.index() * this.step;
    }

    public String reference(AxisName axis) {
        return "BIT" + this.index(axis);
    }

    public AxisUnsigned flagParameter() {
        return this.flagParameter;
    }

    public long flagParameterMask() {
        return this.bitMask;
    }
}

