/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.tuple;

import hep.aida.IManagedObject;
import hep.aida.ITuple;
import hep.aida.ref.tuple.FTuple;
import hep.aida.ref.tuple.FTupleColumn;
import hep.aida.ref.tuple.FTupleCursor;
import java.util.Date;
import org.freehep.util.Value;

public class FTupleAdapter
implements FTuple {
    private ITuple tuple;
    private FTupleColumn[] columns;
    private FTuple[] tuples;
    private FTupleCursor cursor;
    private boolean supportsRandomAccess = false;

    public FTupleAdapter(ITuple tuple) {
        this.setTuple(tuple);
        this.columns = new FTupleColumn[tuple.columns()];
        this.tuples = new FTuple[tuple.columns()];
        this.cursor = new FTupleCursorAdapter(tuple);
        try {
            if (tuple.rows() > 0) {
                this.cursor.setRow(0);
            }
            this.supportsRandomAccess = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.cursor.start();
        for (int i = 0; i < this.columns.length; ++i) {
            this.columns[i] = new FTupleColumnAdapter(tuple, i);
            if (tuple.columnType(i) != ITuple.class) continue;
            this.tuples[i] = new FTupleAdapter(tuple.getTuple(i));
        }
    }

    public void close() {
    }

    public FTupleColumn column(int index) {
        return this.columns[index];
    }

    @Override
    public FTupleColumn columnByName(String name) {
        return this.columns[this.tuple.findColumn(name)];
    }

    @Override
    public FTupleColumn columnByIndex(int index) {
        return this.columns[index];
    }

    @Override
    public String columnName(int index) {
        return this.tuple.columnName(index);
    }

    @Override
    public Class columnType(int index) {
        return this.columns[index].type();
    }

    @Override
    public void columnValue(int column, FTupleCursor cursor, Value value) {
        Class type = this.columnType(column);
        if (type == Integer.TYPE) {
            value.set(this.tuple.getInt(column));
        } else if (type == Short.TYPE) {
            value.set(this.tuple.getShort(column));
        } else if (type == Long.TYPE) {
            value.set(this.tuple.getLong(column));
        } else if (type == Float.TYPE) {
            value.set(this.tuple.getFloat(column));
        } else if (type == Double.TYPE) {
            value.set(this.tuple.getDouble(column));
        } else if (type == Boolean.TYPE) {
            value.set(this.tuple.getBoolean(column));
        } else if (type == Byte.TYPE) {
            value.set(this.tuple.getByte(column));
        } else if (type == Character.TYPE) {
            value.set(this.tuple.getChar(column));
        } else if (type == String.class) {
            value.set(this.tuple.getString(column));
        } else if (type == Date.class) {
            value.set((Date)this.tuple.getObject(column));
        } else {
            value.set(this.tuple.getObject(column));
        }
    }

    @Override
    public int columns() {
        return this.tuple.columns();
    }

    @Override
    public FTupleCursor cursor() throws IllegalStateException {
        return this.cursor;
    }

    @Override
    public boolean isInMemory() {
        return false;
    }

    @Override
    public String name() {
        if (this.tuple instanceof IManagedObject) {
            return ((IManagedObject)this.tuple).name();
        }
        return "title";
    }

    @Override
    public int rows() {
        return this.tuple.rows();
    }

    @Override
    public boolean supportsMultipleCursors() {
        return false;
    }

    @Override
    public boolean supportsRandomAccess() {
        return this.supportsRandomAccess;
    }

    @Override
    public String title() {
        return this.tuple.title();
    }

    @Override
    public FTuple tuple(int index) {
        FTuple fTuple = this.tuples[index];
        ((FTupleAdapter)fTuple).setTuple(this.tuple.getTuple(index));
        return fTuple;
    }

    protected void setTuple(ITuple tuple) {
        this.tuple = tuple;
    }

    private class FTupleCursorAdapter
    implements FTupleCursor {
        private ITuple tuple;
        private int row = -1;

        FTupleCursorAdapter(ITuple tuple) {
            this.tuple = tuple;
        }

        public void close() {
        }

        @Override
        public boolean next() {
            boolean advanced = this.tuple.next();
            if (advanced) {
                ++this.row;
            }
            return advanced;
        }

        @Override
        public int row() {
            return this.row;
        }

        @Override
        public void setRow(int n) {
            this.tuple.setRow(n);
            this.row = n;
        }

        @Override
        public void skip(int rows) {
            this.tuple.skip(rows);
            this.row += rows;
        }

        @Override
        public void start() {
            this.tuple.start();
            this.row = -1;
        }
    }

    private class FTupleColumnAdapter
    implements FTupleColumn {
        private ITuple tuple;
        private int col;

        FTupleColumnAdapter(ITuple tuple, int col) {
            this.tuple = tuple;
            this.col = col;
        }

        @Override
        public boolean hasDefaultValue() {
            return false;
        }

        @Override
        public void defaultValue(Value value) {
        }

        @Override
        public void maxValue(Value value) {
            value.set(this.tuple.columnMax(this.col));
        }

        @Override
        public void meanValue(Value value) {
            value.set(this.tuple.columnMean(this.col));
        }

        @Override
        public void minValue(Value value) {
            value.set(this.tuple.columnMin(this.col));
        }

        @Override
        public String name() {
            return this.tuple.columnName(this.col);
        }

        @Override
        public void rmsValue(Value value) {
            value.set(this.tuple.columnRms(this.col));
        }

        @Override
        public Class type() {
            Class type = this.tuple.columnType(this.col);
            if (type == ITuple.class) {
                return FTuple.class;
            }
            return type;
        }
    }
}

