/*
 * Decompiled with CFR 0.152.
 */
package plotter;

import java.util.Arrays;
import java.util.List;
import javax.swing.event.ChangeListener;
import plotter.Axis;
import plotter.DiscreteAxisModel;
import plotter.TestFrame;

public class StringAxisModel
implements DiscreteAxisModel {
    private final List<String> names;

    StringAxisModel(List<String> names) {
        this.names = names;
    }

    @Override
    public int getNBins() {
        return this.names.size();
    }

    @Override
    public int getBinFromAxisCoordinate(double axisCoordinate) {
        return (int)Math.floor(axisCoordinate * (double)this.getNBins());
    }

    @Override
    public double getLowerAxisCoordinateFromBin(int bin) {
        return (double)bin / (double)this.getNBins();
    }

    @Override
    public double getUpperAxisCoordinateFromBin(int bin) {
        return ((double)bin + 1.0) / (double)this.getNBins();
    }

    @Override
    public String getBinName(int bin) {
        return this.names.get(bin);
    }

    @Override
    public void addChangeListener(ChangeListener l) {
    }

    @Override
    public void removeChangeListener(ChangeListener l) {
    }

    public static void main(String[] args) {
        String[] months = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
        StringAxisModel model = new StringAxisModel(Arrays.asList(months));
        Axis axis = new Axis(model, Axis.AxisPosition.BOTTOM);
        new TestFrame("String Axis Test", axis);
    }
}

