/*
 * Decompiled with CFR 0.152.
 */
package plotter;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;

public class LabelRenderer {
    private final FontMetrics fm;

    LabelRenderer(FontMetrics fm) {
        this.fm = fm;
    }

    float getWidth(String text) {
        String[] tokens = text.split("\\^");
        float w = this.fm.stringWidth(tokens[0]);
        if (tokens.length > 1) {
            w += (float)this.fm.stringWidth(tokens[1]) / 1.5f;
        }
        return w;
    }

    float getHeight(String text) {
        return this.fm.getHeight();
    }

    float getAscent(String text) {
        return this.fm.getAscent();
    }

    float getDescent(String text) {
        return this.fm.getDescent();
    }

    void render(Graphics2D g, float x, float y, String text) {
        String[] tokens = text.split("\\^");
        Font originalFont = g.getFont();
        Font f1 = this.fm.getFont();
        g.setFont(f1);
        g.drawString(tokens[0], x, y);
        if (tokens.length > 1) {
            Rectangle2D bounds = this.fm.getStringBounds(tokens[0], g);
            Font f2 = f1.deriveFont(f1.getSize2D() / 1.5f);
            g.setFont(f2);
            g.drawString(tokens[1], x + (float)bounds.getWidth(), y - (float)(this.fm.getAscent() / 2));
        }
        g.setFont(originalFont);
    }
}

