/*
 * Decompiled with CFR 0.152.
 */
package plotter;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.geom.Line2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.colorchooser.DefaultColorSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import menus.BackgroundColorMenu;
import menus.ColorMenu;
import menus.IncludeInMenu;
import menus.MenuUtils;
import org.freehep.swing.popup.HasPopupItems;
import plotter.Axis;
import plotter.AxisLabeler;
import plotter.AxisModel;
import plotter.DataOverlay;

public class DataArea
extends JComponent
implements HasPopupItems {
    private Axis xAxis;
    private Axis yAxis;
    private List<DataOverlay> data = new ArrayList<DataOverlay>();
    private GridStyle showGrid = GridStyle.BOTH;
    private GridLineStyle gridLineStyle = GridLineStyle.DOTTED;
    private Map<AxisModel, Axis> axisMap = new HashMap<AxisModel, Axis>();

    public DataArea(Axis xAxis, Axis yAxis) {
        this.xAxis = xAxis;
        this.addAxis(xAxis);
        this.yAxis = yAxis;
        this.addAxis(yAxis);
        ChangeListener cl = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                DataArea.this.repaint();
            }
        };
        xAxis.getModel().addChangeListener(cl);
        yAxis.getModel().addChangeListener(cl);
        this.setToolTipText("");
        this.setPreferredSize(new Dimension(400, 400));
    }

    public void addAxis(Axis axis) {
        this.axisMap.put(axis.getModel(), axis);
    }

    Axis getAxisForModel(AxisModel model) {
        return this.axisMap.get(model);
    }

    @IncludeInMenu(value="Grid Style")
    public void setGridLineStyle(GridLineStyle lineStyle) {
        this.gridLineStyle = lineStyle;
        this.repaint();
    }

    public GridLineStyle getGridLineStyle() {
        return this.gridLineStyle;
    }

    @IncludeInMenu(value="Show Grid")
    public void setShowGrid(GridStyle showGrid) {
        this.showGrid = showGrid;
        this.repaint();
    }

    public GridStyle getShowGrid() {
        return this.showGrid;
    }

    @Override
    public String getToolTipText(MouseEvent me) {
        String xText = this.xAxis.getToolTipText(me);
        String yText = this.yAxis.getToolTipText(me);
        StringBuilder builder = new StringBuilder();
        if (!this.empty(xText)) {
            builder.append("x=").append(xText);
        }
        if (!this.empty(xText) && !this.empty(yText)) {
            builder.append(' ');
        }
        if (!this.empty(yText)) {
            builder.append("y=").append(yText);
        }
        return builder.toString();
    }

    public JPopupMenu modifyPopupMenu(JPopupMenu menu, Component source, Point p) {
        MenuUtils.buildMenu(menu, this);
        DefaultColorSelectionModel cm = new DefaultColorSelectionModel(){

            @Override
            public Color getSelectedColor() {
                return DataArea.this.getForeground();
            }

            @Override
            public void setSelectedColor(Color c) {
                DataArea.this.setForeground(c);
            }
        };
        menu.add(new ColorMenu("Grid Color", cm, true));
        cm = new DefaultColorSelectionModel(){

            @Override
            public Color getSelectedColor() {
                System.out.println("Is bg set " + DataArea.this.isBackgroundSet());
                if (!DataArea.this.isBackgroundSet()) {
                    return null;
                }
                return DataArea.this.getBackground();
            }

            @Override
            public void setSelectedColor(Color c) {
                DataArea.this.setBackground(c);
            }
        };
        menu.add(new BackgroundColorMenu("Data Area", cm));
        for (DataOverlay overlay : this.data) {
            MenuUtils.buildMenu(menu, overlay);
        }
        return menu;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.isBackgroundSet()) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.setColor(this.getForeground());
        }
        Graphics2D g2 = (Graphics2D)g;
        if (this.showGrid != GridStyle.NONE) {
            int i;
            int n;
            AxisLabeler labeler;
            BasicStroke stroke = new BasicStroke(1.0f, 2, 0, 10.0f, this.gridLineStyle.getPattern(), 0.0f);
            g2.setStroke(stroke);
            Line2D.Float line = new Line2D.Float();
            if (this.showGrid == GridStyle.BOTH || this.showGrid == GridStyle.VERTICAL) {
                labeler = this.xAxis.getLabeler();
                n = labeler.getNTickMarks();
                double y1 = this.yAxis.getPhysicalCoordinateFromAxisCoordinate(0.0, this);
                double y2 = this.yAxis.getPhysicalCoordinateFromAxisCoordinate(1.0, this);
                for (i = 0; i < n; ++i) {
                    double x = this.xAxis.getPhysicalCoordinateFromAxisCoordinate(labeler.getTickPos(i), this);
                    line.setLine(x, y1, x, y2);
                    g2.draw(line);
                }
            }
            if (this.showGrid == GridStyle.BOTH || this.showGrid == GridStyle.HORIZONTAL) {
                labeler = this.yAxis.getLabeler();
                n = labeler.getNTickMarks();
                double x1 = this.xAxis.getPhysicalCoordinateFromAxisCoordinate(0.0, this);
                double x2 = this.xAxis.getPhysicalCoordinateFromAxisCoordinate(1.0, this);
                for (i = 0; i < n; ++i) {
                    double y = this.yAxis.getPhysicalCoordinateFromAxisCoordinate(labeler.getTickPos(i), this);
                    line.setLine(x1, y, x2, y);
                    g2.draw(line);
                }
            }
        }
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        for (DataOverlay overlay : this.data) {
            overlay.paint(g2);
        }
    }

    public void add(DataOverlay overlay) {
        this.data.add(overlay);
        overlay.setDataArea(this);
    }

    private boolean empty(String yText) {
        return yText == null || yText.length() == 0;
    }

    public static enum GridLineStyle {
        DASHED(4.0f, 6.0f),
        SOLID(new float[0]),
        DOTTED(1.0f, 5.0f),
        DOTDASH(6.0f, 4.0f, 2.0f, 4.0f);

        private float[] pattern;

        private GridLineStyle(float ... pattern) {
            this.pattern = pattern.length == 0 ? null : pattern;
        }

        float[] getPattern() {
            return this.pattern;
        }
    }

    public static enum GridStyle {
        NONE,
        VERTICAL,
        HORIZONTAL,
        BOTH;

    }
}

