/*
 * Decompiled with CFR 0.152.
 */
package plotter;

import java.text.NumberFormat;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import plotter.AxisLabeler;
import plotter.ContinuousAxisModel;
import plotter.LabelSizer;
import plotter.LinearAxisModel;

public class ByteAxisLabeler
implements AxisLabeler,
ChangeListener {
    private static final String[] SINames = new String[]{"B", "kB", "MB", "GB", "TB", "PB", "EB", "ZB", "YB"};
    private static final int SIMultiplier = 1000;
    private static final String[] IECNames = new String[]{"B", "kiB", "MiB", "GiB", "TiB", "PiB", "EiB", "ZiB", "YiB"};
    private static int IECMultiplier = 1024;
    private final ContinuousAxisModel model;
    private final LabelSizer sizer;
    private int nLabels;
    private String[] label;
    private float[] labelPosition;
    private float[] minorTickPositions;
    private String currentName;
    private LabelMode labelMode = LabelMode.IEC;

    @Override
    public void stateChanged(ChangeEvent e) {
        this.calculateAxisLabelsAndPositions();
    }

    ByteAxisLabeler(ContinuousAxisModel model, LabelSizer labelSizer) {
        this.model = model;
        this.sizer = labelSizer;
        labelSizer.addChangeListener(this);
        model.addChangeListener(this);
        this.calculateAxisLabelsAndPositions();
    }

    private void calculateAxisLabelsAndPositions() {
        double min = this.model.getModelCoordinateFromAxisCoordinate(0.0);
        double max = this.model.getModelCoordinateFromAxisCoordinate(1.0);
        double maxSize = (long)Math.max(Math.abs(min), Math.abs(max));
        int nameIndex = this.calculateCurrentUnit(maxSize);
        this.currentName = this.labelMode.names[nameIndex];
        double multiplier = Math.pow(this.labelMode.multiplier, nameIndex);
        this.calculateLabels(min / multiplier, max / multiplier, 1, 20);
    }

    private void calculateLabels(double min, double max, int minNumberOfDivisions, int maxNumberOfDivisions) {
        double inc;
        int nDivisions;
        System.out.println(min + " " + max + " " + minNumberOfDivisions + " " + maxNumberOfDivisions);
        double pow = Math.floor(Math.log10(max - min)) - 1.0;
        int fractDigits = 0;
        if (pow < -0.5) {
            fractDigits = -((int)pow);
        }
        double conversion = Math.pow(10.0, pow);
        int intMin = (int)Math.floor(min / conversion);
        int intMax = (int)Math.ceil(max / conversion);
        int naturalNumberOfDivisions = intMax - intMin;
        float idealMinFraction = 0.5f;
        int nMinorPerMajor = 5;
        int nUnits = 1;
        if (naturalNumberOfDivisions < maxNumberOfDivisions) {
            float proximity = (float)naturalNumberOfDivisions / (float)maxNumberOfDivisions;
            boolean niceDivisionFound = false;
            if (proximity < 0.5f) {
                int candidate;
                int[] divisions = new int[]{2, 4, 5, 10, 20};
                int[] minorTicks = new int[]{4, 4, 5, 5, 4};
                for (int i = 0; i < divisions.length && (double)(proximity * (float)(candidate = divisions[i])) <= 1.0; ++i) {
                    niceDivisionFound = true;
                    nUnits = candidate;
                    nMinorPerMajor = minorTicks[i];
                }
            }
            if (niceDivisionFound) {
                nDivisions = naturalNumberOfDivisions * nUnits + (int)((max / conversion - (double)intMax) * (double)nUnits);
                ++fractDigits;
                if (nUnits > 10) {
                    ++fractDigits;
                }
            } else {
                nDivisions = Math.max(naturalNumberOfDivisions, minNumberOfDivisions);
            }
        } else if (naturalNumberOfDivisions > maxNumberOfDivisions) {
            nDivisions = 1;
            int[] skips = new int[]{2, 5, 10, 20, 25, 50};
            int[] minorTicks = new int[]{4, 5, 5, 4, 5, 5};
            for (int i = 0; i < skips.length; ++i) {
                int nDivisionsThisTry = naturalNumberOfDivisions / skips[i];
                if (nDivisionsThisTry > maxNumberOfDivisions) continue;
                nUnits = skips[i];
                nMinorPerMajor = minorTicks[i];
                nDivisions = nDivisionsThisTry;
                if (nUnits >= 10 && nUnits != 25 && fractDigits > 0) {
                    --fractDigits;
                }
                if (intMin % nUnits != 0) {
                    int increase;
                    int n = increase = intMin > 0 ? nUnits - intMin % nUnits : -intMin % nUnits;
                    if (increase > intMax - (intMax - intMin) / nUnits * nUnits - intMin) {
                        --nDivisions;
                    }
                    intMin += increase;
                }
                break;
            }
        } else {
            nDivisions = Math.max(naturalNumberOfDivisions, minNumberOfDivisions);
        }
        NumberFormat formatter = NumberFormat.getInstance();
        formatter.setMaximumFractionDigits(fractDigits);
        formatter.setMinimumFractionDigits(fractDigits);
        double minLabelValue = (double)intMin * conversion;
        double d = inc = naturalNumberOfDivisions < maxNumberOfDivisions ? conversion / (double)nUnits : conversion * (double)nUnits;
        if (naturalNumberOfDivisions < maxNumberOfDivisions && minLabelValue - inc >= min) {
            int nLost = (int)((minLabelValue - inc) / inc);
            minLabelValue -= (double)nLost * inc;
            nDivisions += nLost;
        }
        this.label = new String[nDivisions + 1];
        this.labelPosition = new float[nDivisions + 1];
        this.nLabels = nDivisions;
        boolean nMinor = false;
        for (int j = -1; j < this.label.length; ++j) {
            double labelValue = minLabelValue + (double)j * inc;
            if (j < 0) continue;
            this.label[j] = formatter.format(labelValue);
            this.labelPosition[j] = (float)((labelValue - min) / (max - min));
        }
    }

    private int calculateCurrentUnit(double maxSize) {
        int nameIndex = 0;
        while (maxSize > (double)this.labelMode.multiplier) {
            maxSize /= (double)this.labelMode.multiplier;
            ++nameIndex;
        }
        return nameIndex;
    }

    @Override
    public int getNLabels() {
        return this.nLabels;
    }

    @Override
    public String getLabel(int index) {
        return this.label[index];
    }

    @Override
    public float getLabelPos(int index) {
        return this.labelPosition[index];
    }

    @Override
    public int getNTickMarks() {
        return this.nLabels;
    }

    @Override
    public float getTickPos(int index) {
        return this.labelPosition[index];
    }

    @Override
    public int getNMinorTickMarks() {
        return 0;
    }

    @Override
    public float getMinorTickPos(int index) {
        return 0.0f;
    }

    @Override
    public String getToolTipText(float pos) {
        return null;
    }

    @Override
    public String getAxisUnit() {
        return this.currentName;
    }

    public static void main(String[] args) {
        LinearAxisModel model = new LinearAxisModel(2.13909504E9, 2.147483648E9);
        ByteAxisLabeler labeler = new ByteAxisLabeler(model, null);
        System.out.println(labeler.currentName);
        for (String label : labeler.label) {
            System.out.println(label);
        }
    }

    static /* synthetic */ String[] access$000() {
        return SINames;
    }

    static /* synthetic */ String[] access$100() {
        return IECNames;
    }

    static /* synthetic */ int access$200() {
        return IECMultiplier;
    }

    public static enum LabelMode {
        SI(ByteAxisLabeler.access$000(), 1000),
        IEC(ByteAxisLabeler.access$100(), ByteAxisLabeler.access$200()),
        IECwithSINames(ByteAxisLabeler.access$000(), ByteAxisLabeler.access$200());

        private String[] names;
        private int multiplier;

        private LabelMode(String[] names, int multiplier) {
            this.names = names;
            this.multiplier = multiplier;
        }
    }
}

