/*
 * Decompiled with CFR 0.152.
 */
package plotter;

import plotter.AxisLabelFormatter;
import plotter.LabelSizer;

class BasicAxisLabeler {
    private final int maxCharsPerLabel = 5;
    private final int minSpaceBetweenLabels = 3;
    private final int minNumberOfDivisions = 1;
    private LabelSizer sizer;
    private int nDivisions = 0;
    private double min = 0.0;
    private double max = 1.0;
    private String[] labels;
    private double[] labelPositions;
    private double[] minorTickPositions;
    private int scale_power;
    private boolean hideMinorTicks = false;
    private boolean labelsValid = false;
    private AxisLabelFormatter format;

    BasicAxisLabeler(double min, double max, LabelSizer sizer) {
        this.min = min;
        this.max = max;
        this.sizer = sizer;
    }

    void invalidate() {
        this.labelsValid = false;
    }

    public int getPower() {
        return this.scale_power;
    }

    String getToolTipText(float pos) {
        double v = this.min + (this.max - this.min) * (double)pos;
        return this.format.formatToolTip(v);
    }

    public int getNLabels() {
        if (!this.labelsValid) {
            this.calculateLabels();
        }
        return this.labels.length;
    }

    public String getLabel(int index) {
        if (!this.labelsValid) {
            this.calculateLabels();
        }
        return this.labels[index];
    }

    private long round(double d, boolean down) {
        block3: {
            double round;
            block2: {
                double minProximity = 1.0E-4;
                round = Math.round(d);
                if (d == round) break block2;
                double d2 = Math.abs(d - round);
                double d3 = d != 0.0 ? 1.0E-4 * Math.abs(d) : 1.0E-6;
                if (!(d2 < d3)) break block3;
            }
            return (long)round;
        }
        return down ? (long)Math.floor(d) : (long)Math.ceil(d);
    }

    private void calculateLabels() {
        double inc;
        int nDivisions;
        int maxNumberOfDivisions = (int)(1.0 / ((double)this.sizer.getSize("2,000") + 0.01));
        this.labelsValid = true;
        double log_max = this.max == 0.0 ? 0.0 : Math.log10(Math.abs(this.max));
        int int_log_max = (int)Math.floor(log_max);
        this.scale_power = 0;
        if (Math.abs(int_log_max) >= 5) {
            this.scale_power = int_log_max;
        }
        this.format = new AxisLabelFormatter(this.scale_power);
        this.minorTickPositions = null;
        double difference = this.max - this.min;
        double pow = Math.floor(Math.log10(difference)) - 1.0;
        int fractDigits = 0;
        if (this.scale_power > 0) {
            fractDigits = this.scale_power - (int)pow;
        } else if (pow < -0.5) {
            fractDigits = this.scale_power - (int)pow;
        }
        double conversion = Math.pow(10.0, pow);
        long intMin = this.round(this.min / conversion, false);
        long intMax = this.round(this.max / conversion, true);
        int naturalNumberOfDivisions = (int)(intMax - intMin);
        float idealMinFraction = 0.5f;
        int nMinorPerMajor = 5;
        int nUnits = 1;
        if (naturalNumberOfDivisions < maxNumberOfDivisions) {
            float proximity = (float)naturalNumberOfDivisions / (float)maxNumberOfDivisions;
            boolean niceDivisionFound = false;
            if (proximity < 0.5f) {
                int candidate;
                int[] divisions = new int[]{2, 4, 5, 10, 20};
                int[] minorTicks = new int[]{4, 4, 5, 5, 4};
                for (int i = 0; i < divisions.length && (double)(proximity * (float)(candidate = divisions[i])) <= 1.0; ++i) {
                    niceDivisionFound = true;
                    nUnits = candidate;
                    nMinorPerMajor = minorTicks[i];
                }
            }
            if (niceDivisionFound) {
                nDivisions = naturalNumberOfDivisions * nUnits + (int)((this.max / conversion - (double)intMax) * (double)nUnits);
                if (pow < 0.5 || this.scale_power > 0) {
                    ++fractDigits;
                }
                if (!(nUnits != 4 && nUnits != 20 || !(pow < 1.5) && this.scale_power <= 0)) {
                    ++fractDigits;
                }
            } else {
                nDivisions = Math.max(naturalNumberOfDivisions, 1);
            }
        } else if (naturalNumberOfDivisions > maxNumberOfDivisions) {
            nDivisions = 1;
            int[] skips = new int[]{2, 5, 10, 20, 25, 50};
            int[] minorTicks = new int[]{4, 5, 5, 4, 5, 5};
            for (int i = 0; i < skips.length; ++i) {
                int nDivisionsThisTry = naturalNumberOfDivisions / skips[i];
                if (nDivisionsThisTry > maxNumberOfDivisions) continue;
                nUnits = skips[i];
                nMinorPerMajor = minorTicks[i];
                nDivisions = nDivisionsThisTry;
                if (nUnits >= 10 && nUnits != 25 && fractDigits > 0) {
                    --fractDigits;
                }
                if (intMin % (long)nUnits != 0L) {
                    long increase;
                    long l = increase = intMin > 0L ? (long)nUnits - intMin % (long)nUnits : -intMin % (long)nUnits;
                    if (increase > intMax - (intMax - intMin) / (long)nUnits * (long)nUnits - intMin) {
                        --nDivisions;
                    }
                    intMin += increase;
                }
                break;
            }
        } else {
            nDivisions = Math.max(naturalNumberOfDivisions, 1);
        }
        double minLabelValue = (double)intMin * conversion;
        double d = inc = naturalNumberOfDivisions < maxNumberOfDivisions ? conversion / (double)nUnits : conversion * (double)nUnits;
        if (naturalNumberOfDivisions < maxNumberOfDivisions && minLabelValue - inc >= this.min) {
            int nLost = (int)((minLabelValue - inc) / inc);
            minLabelValue -= (double)nLost * inc;
            nDivisions += nLost;
        }
        System.err.println(nDivisions + " " + maxNumberOfDivisions + " " + this.min + " " + this.max);
        this.labels = new String[nDivisions + 1];
        this.labelPositions = new double[nDivisions + 1];
        this.nDivisions = nDivisions;
        this.format.setFractionDigits(fractDigits);
        int nMinor = 0;
        this.minorTickPositions = new double[(nMinorPerMajor - 1) * (this.labels.length + 1)];
        for (int j = -1; j < this.labels.length; ++j) {
            double labelValue = minLabelValue + (double)j * inc;
            if (j >= 0) {
                this.labels[j] = this.format.format(labelValue);
                this.labelPositions[j] = (labelValue - this.min) / (this.max - this.min);
            }
            for (int k = 1; k < nMinorPerMajor; ++k) {
                double tickPos = (labelValue + (double)k * inc / (double)nMinorPerMajor - this.min) / (this.max - this.min);
                if (!(tickPos >= 0.0) || !(tickPos < 1.00001)) continue;
                this.minorTickPositions[nMinor++] = tickPos;
            }
        }
    }

    float getLabelPosition(int index) {
        if (!this.labelsValid) {
            this.calculateLabels();
        }
        return (float)this.labelPositions[index];
    }

    int getNMinorTickMarks() {
        if (!this.labelsValid) {
            this.calculateLabels();
        }
        return this.minorTickPositions.length;
    }

    float getMinorTickPos(int index) {
        if (!this.labelsValid) {
            this.calculateLabels();
        }
        return (float)this.minorTickPositions[index];
    }

    void setRange(double min, double max) {
        this.min = min;
        this.max = max;
        this.labelsValid = false;
    }
}

