/*
 * Decompiled with CFR 0.152.
 */
package plotter;

import hep.aida.IAnalysisFactory;
import hep.aida.IAxis;
import hep.aida.IHistogram2D;
import hep.aida.IHistogramFactory;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.Random;
import javax.swing.JPanel;
import plotter.Axis;
import plotter.ColorTest;
import plotter.DataArea;
import plotter.DefaultAxisModel;
import plotter.Histogram2DOverlay;
import plotter.PlotLayout;
import plotter.RainbowColorMap;
import plotter.SimpleContinuousAxisModel;
import plotter.TestFrame;

public class AIDA2DTest {
    public static void main(String[] args) {
        IAnalysisFactory af = IAnalysisFactory.create();
        IHistogramFactory hf = af.createHistogramFactory(af.createTreeFactory().create());
        IHistogram2D h1 = hf.createHistogram2D("test", 40, -3.0, 3.0, 40, -3.0, 3.0);
        IHistogram2D h2 = hf.createHistogram2D("test", 2048, -1.0, 5.0, 2048, -1.0, 5.0);
        Random r = new Random();
        for (int i = 0; i < 1000000; ++i) {
            h1.fill(r.nextGaussian(), r.nextGaussian());
            h2.fill(r.nextGaussian() + 2.0, r.nextGaussian() + 2.0);
        }
        IAxis xAxis = h2.xAxis();
        double[] xEdges = new double[xAxis.bins() + 1];
        for (int i = 0; i < xAxis.bins(); ++i) {
            xEdges[i] = xAxis.binLowerEdge(i);
        }
        xEdges[xAxis.bins()] = xAxis.upperEdge();
        IAxis yAxis = h2.yAxis();
        double[] yEdges = new double[yAxis.bins() + 1];
        for (int i = 0; i < yAxis.bins(); ++i) {
            yEdges[i] = yAxis.binLowerEdge(i);
        }
        yEdges[yAxis.bins()] = yAxis.upperEdge();
        double zMin = 0.0;
        double zMax = 0.0;
        for (int i = 0; i < xAxis.bins(); ++i) {
            for (int j = 0; j < yAxis.bins(); ++j) {
                double z = h2.binHeight(i, j);
                if (i == 0 && j == 0) {
                    zMin = zMax = z;
                    continue;
                }
                zMin = Math.min(zMin, z);
                zMax = Math.max(zMax, z);
            }
        }
        DefaultAxisModel xModel = new DefaultAxisModel(xEdges, false, false);
        DefaultAxisModel yModel = new DefaultAxisModel(yEdges, false, false);
        SimpleContinuousAxisModel zModel = new SimpleContinuousAxisModel(zMin, zMax);
        Axis bottomAxis = new Axis(xModel, Axis.AxisPosition.BOTTOM);
        Axis leftAxis = new Axis(yModel, Axis.AxisPosition.LEFT);
        RainbowColorMap cm = new RainbowColorMap();
        Histogram2DOverlay overlay = new Histogram2DOverlay(h2.title(), h2, bottomAxis, leftAxis, zModel, cm);
        DataArea da = new DataArea(bottomAxis, leftAxis);
        da.setBackground(Color.WHITE);
        da.add(overlay);
        JPanel plotPanel = new JPanel(new PlotLayout());
        plotPanel.add((Component)bottomAxis, "South");
        plotPanel.add((Component)leftAxis, "West");
        plotPanel.add((Component)da, "Center");
        JPanel fullPanel = new JPanel(new BorderLayout());
        fullPanel.add((Component)plotPanel, "Center");
        fullPanel.add((Component)new ColorTest(new Axis(zModel, Axis.AxisPosition.LEFT), cm), "East");
        new TestFrame("AIDATest", fullPanel);
    }
}

