/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.image.compression.hdu;

import java.nio.Buffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nom.tam.fits.BinaryTableHDU;
import nom.tam.fits.FitsException;
import nom.tam.fits.Header;
import nom.tam.fits.HeaderCard;
import nom.tam.fits.ImageData;
import nom.tam.fits.ImageHDU;
import nom.tam.fits.compression.algorithm.api.ICompressOption;
import nom.tam.fits.header.Compression;
import nom.tam.fits.header.GenericKey;
import nom.tam.fits.header.IFitsHeader;
import nom.tam.fits.header.Standard;
import nom.tam.image.compression.hdu.BackupRestoreUnCompressedHeaderCard;
import nom.tam.image.compression.hdu.CompressedImageData;
import nom.tam.util.Cursor;

public class CompressedImageHDU
extends BinaryTableHDU {
    static final List<IFitsHeader> TABLE_COLUMN_KEYS = Collections.unmodifiableList(Arrays.asList(CompressedImageHDU.binaryTableColumnKeyStems()));
    static final Map<IFitsHeader, BackupRestoreUnCompressedHeaderCard> COMPRESSED_HEADER_MAPPING = new HashMap<IFitsHeader, BackupRestoreUnCompressedHeaderCard>();
    static final Map<IFitsHeader, BackupRestoreUnCompressedHeaderCard> UNCOMPRESSED_HEADER_MAPPING = new HashMap<IFitsHeader, BackupRestoreUnCompressedHeaderCard>();

    public static CompressedImageHDU fromImageHDU(ImageHDU imageHDU, int ... tileAxis) throws FitsException {
        Header header = new Header();
        CompressedImageData compressedData = new CompressedImageData();
        compressedData.setAxis(imageHDU.getAxes());
        if (tileAxis.length > 0) {
            compressedData.setTileSize(tileAxis);
        }
        compressedData.fillHeader(header);
        Cursor<String, HeaderCard> iterator = header.iterator();
        Cursor<String, HeaderCard> imageIterator = imageHDU.getHeader().iterator();
        while (imageIterator.hasNext()) {
            HeaderCard card = (HeaderCard)imageIterator.next();
            BackupRestoreUnCompressedHeaderCard.restore(card, iterator);
        }
        CompressedImageHDU compressedImageHDU = new CompressedImageHDU(header, compressedData);
        compressedData.prepareUncompressedData(((ImageData)imageHDU.getData()).getData(), header);
        return compressedImageHDU;
    }

    public static boolean isHeader(Header hdr) {
        return hdr.getBooleanValue(Compression.ZIMAGE, false);
    }

    public static CompressedImageData manufactureData(Header hdr) throws FitsException {
        return new CompressedImageData(hdr);
    }

    public CompressedImageHDU(Header hdr, CompressedImageData datum) {
        super(hdr, datum);
    }

    public ImageHDU asImageHDU() throws FitsException {
        Header header = new Header();
        Cursor<String, HeaderCard> imageIterator = header.iterator();
        Cursor<String, HeaderCard> iterator = this.getHeader().iterator();
        while (iterator.hasNext()) {
            HeaderCard card = (HeaderCard)iterator.next();
            if (TABLE_COLUMN_KEYS.contains(GenericKey.lookup(card.getKey()))) continue;
            BackupRestoreUnCompressedHeaderCard.backup(card, imageIterator);
        }
        ImageData data = (ImageData)ImageHDU.manufactureData(header);
        ImageHDU imageHDU = new ImageHDU(header, data);
        data.setBuffer(this.getUncompressedData());
        return imageHDU;
    }

    public void compress() throws FitsException {
        this.getData().compress(this);
    }

    public CompressedImageHDU forceNoLoss(int x, int y, int width, int heigth) {
        this.getData().forceNoLoss(x, y, width, heigth);
        return this;
    }

    public <T extends ICompressOption> T getCompressOption(Class<T> clazz) {
        return this.getData().getCompressOption(clazz);
    }

    @Override
    public CompressedImageData getData() {
        return (CompressedImageData)super.getData();
    }

    public Buffer getUncompressedData() throws FitsException {
        return this.getData().getUncompressedData(this.getHeader());
    }

    @Override
    public boolean isHeader() {
        return super.isHeader() && CompressedImageHDU.isHeader(this.myHeader);
    }

    public CompressedImageHDU preserveNulls(String compressionAlgorithm) {
        long nullValue = this.getHeader().getLongValue(Standard.BLANK, Long.MIN_VALUE);
        this.getData().preserveNulls(nullValue, compressionAlgorithm);
        return this;
    }

    public CompressedImageHDU setCompressAlgorithm(String compressAlgorithm) throws FitsException {
        HeaderCard compressAlgorithmCard = this.getHeader().card(Compression.ZCMPTYPE).value(compressAlgorithm).card();
        this.getData().setCompressAlgorithm(compressAlgorithmCard);
        return this;
    }

    public CompressedImageHDU setQuantAlgorithm(String quantAlgorithm) throws FitsException {
        if (quantAlgorithm != null && !quantAlgorithm.isEmpty()) {
            HeaderCard quantAlgorithmCard = this.getHeader().card(Compression.ZQUANTIZ).value(quantAlgorithm).card();
            this.getData().setQuantAlgorithm(quantAlgorithmCard);
        } else {
            this.getData().setQuantAlgorithm(null);
        }
        return this;
    }
}

