/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.renderer;

import javax.swing.AbstractButton;
import org.jdesktop.swingx.renderer.BooleanValue;
import org.jdesktop.swingx.renderer.CellContext;
import org.jdesktop.swingx.renderer.ComponentProvider;
import org.jdesktop.swingx.renderer.JRendererCheckBox;
import org.jdesktop.swingx.renderer.StringValue;
import org.jdesktop.swingx.renderer.StringValues;

public class CheckBoxProvider
extends ComponentProvider<AbstractButton> {
    private boolean borderPainted;

    public CheckBoxProvider() {
        this(null);
    }

    public CheckBoxProvider(StringValue stringValue) {
        this(stringValue, 0);
    }

    public CheckBoxProvider(StringValue stringValue, int alignment) {
        super(stringValue == null ? StringValues.EMPTY : stringValue, alignment);
        this.setBorderPainted(true);
    }

    public boolean isBorderPainted() {
        return this.borderPainted;
    }

    public void setBorderPainted(boolean borderPainted) {
        this.borderPainted = borderPainted;
    }

    @Override
    protected void format(CellContext context) {
        ((AbstractButton)this.rendererComponent).setSelected(this.getValueAsBoolean(context));
        ((AbstractButton)this.rendererComponent).setText(this.getValueAsString(context));
    }

    protected boolean getValueAsBoolean(CellContext context) {
        if (this.formatter instanceof BooleanValue) {
            return ((BooleanValue)((Object)this.formatter)).getBoolean(context.getValue());
        }
        return Boolean.TRUE.equals(context.getValue());
    }

    @Override
    protected void configureState(CellContext context) {
        ((AbstractButton)this.rendererComponent).setBorderPainted(this.isBorderPainted());
        ((AbstractButton)this.rendererComponent).setHorizontalAlignment(this.getHorizontalAlignment());
    }

    @Override
    protected AbstractButton createRendererComponent() {
        return new JRendererCheckBox();
    }
}

