/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shutter.gui;

import data.DiscretePlotData;
import data.MetaData;
import data.MutablePlotData;
import data.PlotDataListener;
import data.SuggestedRange;
import java.util.ArrayList;
import java.util.List;
import org.freehep.util.Value;
import org.lsst.ccs.subsystem.shutter.sim.PredictedPosition;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;
import util.ListenerList;

public class PredictionPlotData
implements DiscretePlotData,
MutablePlotData {
    public static final int TIME = 0;
    public static final int ACCELERATION = 1;
    public static final int VELOCITY = 2;
    public static final int POSITION = 3;
    private final List<PredictionPoint> data = new ArrayList<PredictionPoint>();
    private final ListenerList<PlotDataListener> listeners = new ListenerList();
    private final String[] names = new String[]{"Time", "Acceleration", "Velocity", "Position"};

    public void reset() {
        this.data.clear();
        this.firePlotDataChanged();
    }

    public void addData(List<PredictedPosition> pos, CCSTimeStamp t0) {
        double vscale = pos.stream().mapToDouble(p -> Math.abs(p.getVelocity())).max().orElse(1.0);
        double ascale = pos.stream().mapToDouble(p -> Math.abs(p.getAcceleration())).max().orElse(1.0);
        for (PredictedPosition p2 : pos) {
            this.data.add(new PredictionPoint((double)p2.timeDiff(t0).toMillis() * 0.001, p2.getAcceleration() / ascale, p2.getVelocity() / vscale, p2.getPosition()));
        }
        this.firePlotDataChanged();
    }

    public int getNPoints() {
        return this.data.size();
    }

    public int getNDimensions() {
        return this.names.length;
    }

    public String names(int index) {
        return this.names[index];
    }

    public Class types(int index) {
        return Double.TYPE;
    }

    public void getValue(Value value, int dim, int index) {
        PredictionPoint point = this.data.get(index);
        switch (dim) {
            case 0: {
                value.set(point.getTime());
                break;
            }
            case 1: {
                value.set(point.getAcceleration());
                break;
            }
            case 2: {
                value.set(point.getVelocity());
                break;
            }
            case 3: {
                value.set(point.getPosition());
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("dim is out of bounds.");
            }
        }
    }

    public MetaData getMetaData() {
        return null;
    }

    public String getTitle() {
        return "Predicted trajectory";
    }

    public SuggestedRange getSuggestedRange() {
        return null;
    }

    public void addPlotDataListener(PlotDataListener listener) {
        this.listeners.addListener((Object)listener);
    }

    public void removePlotDataListener(PlotDataListener listener) {
        this.listeners.removeListener((Object)listener);
    }

    private void firePlotDataChanged() {
        if (!this.listeners.isEmpty()) {
            for (PlotDataListener l : this.listeners.getListeners()) {
                l.dataChanged();
            }
        }
    }

    public Object lock() {
        throw new UnsupportedOperationException("Locking isn't implemented.");
    }

    private static class PredictionPoint {
        private final double time;
        private final double acceleration;
        private final double velocity;
        private final double position;

        public PredictionPoint(double time, double acceleration, double velocity, double position) {
            this.time = time;
            this.acceleration = acceleration;
            this.velocity = velocity;
            this.position = position;
        }

        public double getAcceleration() {
            return this.acceleration;
        }

        public double getTime() {
            return this.time;
        }

        public double getPosition() {
            return this.position;
        }

        public double getVelocity() {
            return this.velocity;
        }
    }
}

