/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.messaging.util;

import java.util.concurrent.locks.LockSupport;
import java.util.logging.Level;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.messages.BusMessage;
import org.lsst.ccs.messaging.util.Dispatcher;

public class Throttle {
    static final long MIN_DELAY = 1000L;
    private static final long VETO_TIME = -129542144L;
    private static final double VETO_FACTOR = 2.0;
    private final Dispatcher dispatcher;
    private final Alert alert;
    private final long maxSize;
    private final double maxRate;
    private long prevDelay;
    private long prevTime;
    private long accSize = 0L;
    private long accTime = System.nanoTime();

    public Throttle(Dispatcher dispatcher, String alertID, int sizeMB, int rateMB) {
        this.maxSize = (long)sizeMB * 1000000L;
        this.maxRate = (double)rateMB / 1000.0;
        this.alert = new Alert(alertID, "Message rate alert.");
        this.dispatcher = dispatcher;
    }

    public void process(BusMessage message) {
        long delay;
        long size = message.getSize();
        if (size <= 0L) {
            return;
        }
        long now = System.nanoTime();
        this.accSize = Math.max(0L, Math.round((double)this.accSize - this.maxRate * (double)(now - this.accTime)));
        this.accSize += size;
        this.accTime = now;
        if (this.accSize > this.maxSize && (delay = Math.round((double)(this.accSize - this.maxSize) / this.maxRate)) > 1000L) {
            if ((double)delay > (double)this.prevDelay * 2.0 || now > this.prevTime + -129542144L) {
                Level level = delay > 1000000000L ? Level.WARNING : Level.FINE;
                this.dispatcher.getLogger().log(level, "Throttle: {0} {1} of size {2} is held for {3} ms.", new Object[]{this.alert.getAlertId(), message.getClass().getSimpleName(), size, delay / 1000000L});
                this.prevDelay = delay;
                this.prevTime = now;
            }
            LockSupport.parkNanos(delay);
            now = System.nanoTime();
            this.accSize = Math.max(0L, Math.round((double)this.accSize - this.maxRate * (double)(now - this.accTime)));
            this.accTime = now;
        }
    }
}

