/*
 * Decompiled with CFR 0.152.
 */
package plotter;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import org.freehep.util.images.ImageHandler;

public class TextureChooser
extends JPanel {
    public static Object texture = TextureChooser.getGeomTexture();
    public int num;

    public TextureChooser(int num) {
        this.num = num;
        this.setLayout(new GridLayout(0, 2, 5, 5));
        this.setBorder(new TitledBorder(new EtchedBorder(), "Texture Chooser"));
        this.add(new Surface(TextureChooser.getGeomTexture(), this, 0));
        this.add(new Surface(this.getImageTexture(), this, 1));
        this.add(new Surface(this.getTextTexture(), this, 2));
        this.add(new Surface(this.getGradientPaint(), this, 3));
    }

    public static TexturePaint getGeomTexture() {
        BufferedImage bi = new BufferedImage(5, 5, 1);
        Graphics2D tG2 = bi.createGraphics();
        tG2.setBackground(Color.white);
        tG2.clearRect(0, 0, 5, 5);
        tG2.setColor(new Color(211, 211, 211, 200));
        tG2.fill(new Ellipse2D.Float(0.0f, 0.0f, 5.0f, 5.0f));
        Rectangle r = new Rectangle(0, 0, 5, 5);
        return new TexturePaint(bi, r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TexturePaint getImageTexture() {
        Image img = ImageHandler.getImage((String)"raindrops_light.gif", this.getClass());
        ImageObserver obs = new ImageObserver(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
                if ((infoflags & 0x20) != 0) {
                    1 var7_7 = this;
                    synchronized (var7_7) {
                        this.notifyAll();
                    }
                    return false;
                }
                return true;
            }
        };
        this.prepareImage(img, obs);
        try {
            ImageObserver imageObserver = obs;
            synchronized (imageObserver) {
                obs.wait();
            }
        }
        catch (InterruptedException x) {
            // empty catch block
        }
        int iw = img.getWidth(obs);
        int ih = img.getHeight(obs);
        BufferedImage bi = new BufferedImage(iw, ih, 1);
        Graphics2D tG2 = bi.createGraphics();
        tG2.drawImage(img, 0, 0, this);
        Rectangle r = new Rectangle(0, 0, iw, ih);
        return new TexturePaint(bi, r);
    }

    public TexturePaint getTextTexture() {
        Font f = new Font("Times New Roman", 1, 10);
        TextLayout tl = new TextLayout("Java2D", f, new FontRenderContext(null, false, false));
        int sw = (int)tl.getBounds().getWidth();
        int sh = (int)(tl.getAscent() + tl.getDescent());
        BufferedImage bi = new BufferedImage(sw, sh, 1);
        Graphics2D tG2 = bi.createGraphics();
        tG2.setBackground(Color.white);
        tG2.clearRect(0, 0, sw, sh);
        tG2.setColor(Color.lightGray);
        tl.draw(tG2, 0.0f, tl.getAscent());
        Rectangle r = new Rectangle(0, 0, sw, sh);
        return new TexturePaint(bi, r);
    }

    public GradientPaint getGradientPaint() {
        return new GradientPaint(0.0f, 0.0f, Color.white, 80.0f, 0.0f, Color.green);
    }

    public static void main(String[] s) {
        Frame f = new Frame("Java2D Demo - TextureChooser");
        f.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        f.add("Center", new TextureChooser(0));
        f.pack();
        f.setSize(new Dimension(400, 400));
        f.setVisible(true);
    }

    public class Surface
    extends JPanel
    implements MouseListener {
        public boolean clickedFrame;
        private int num;
        private TextureChooser tc;
        private boolean enterExitFrame = false;
        private Object t;

        public Surface(Object t, TextureChooser tc, int num) {
            this.setBackground(Color.white);
            this.t = t;
            this.tc = tc;
            this.clickedFrame = num == tc.num;
            this.num = num;
            if (num == tc.num) {
                texture = t;
            }
            this.addMouseListener(this);
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2 = (Graphics2D)g;
            int w = this.getSize().width;
            int h = this.getSize().height;
            if (this.t instanceof TexturePaint) {
                g2.setPaint((TexturePaint)this.t);
            } else {
                g2.setPaint((GradientPaint)this.t);
            }
            g2.fill(new Rectangle(0, 0, w, h));
            if (this.clickedFrame || this.enterExitFrame) {
                g2.setColor(Color.gray);
                BasicStroke bs = new BasicStroke(3.0f, 0, 0);
                g2.setStroke(bs);
                g2.drawRect(0, 0, w - 1, h - 1);
                this.tc.num = this.num;
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            texture = this.t;
            this.clickedFrame = true;
            Component[] cmps = this.tc.getComponents();
            for (int i = 0; i < cmps.length; ++i) {
                Surface surf;
                if (!(cmps[i] instanceof Surface) || (surf = (Surface)cmps[i]).equals(this) || !surf.clickedFrame) continue;
                surf.clickedFrame = false;
                surf.repaint();
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.enterExitFrame = true;
            this.repaint();
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.enterExitFrame = false;
            this.repaint();
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(30, 30);
        }
    }
}

