/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.image.samp;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.astrogrid.samp.Client;
import org.astrogrid.samp.Message;
import org.astrogrid.samp.Metadata;
import org.astrogrid.samp.Response;
import org.astrogrid.samp.client.ClientProfile;
import org.astrogrid.samp.client.DefaultClientProfile;
import org.astrogrid.samp.client.HubConnector;
import org.astrogrid.samp.client.ResultHandler;
import org.astrogrid.samp.client.SampException;
import org.astrogrid.samp.hub.Hub;
import org.astrogrid.samp.hub.HubServiceMode;

public class SampUtils
implements Closeable {
    private final HubConnector conn;
    private static final Logger log = Logger.getLogger(SampUtils.class.getName());
    private static final int DEFAULT_TIMEOUT = 10000;

    public SampUtils(String name, boolean autoStartHub) {
        ClientProfile profile = DefaultClientProfile.getProfile();
        this.conn = new HubConnector(profile);
        Metadata meta = new Metadata();
        meta.setName(name == null ? "CCS" : name);
        meta.setDescriptionText("CCS interface to SAMP for subsystem " + name);
        this.conn.declareMetadata((Map)meta);
        this.conn.declareSubscriptions((Map)this.conn.computeSubscriptions());
        if (!this.conn.isConnected()) {
            if (autoStartHub) {
                try {
                    Hub.checkExternalHubAvailability();
                    Hub.runExternalHub((HubServiceMode)HubServiceMode.NO_GUI);
                    log.info("SAMP hub spawned.");
                    long start = System.currentTimeMillis();
                    long timeout = 10000L;
                    while (this.conn.getConnection() == null) {
                        if (System.currentTimeMillis() - start > timeout) {
                            throw new IOException("timeout while waiting to connect to recently started SAMP hub");
                        }
                        log.log(Level.INFO, "Waiting for samp hub to start");
                        Thread.sleep(100L);
                    }
                }
                catch (IOException | InterruptedException ex) {
                    log.log(Level.WARNING, "Unable to create SAMP hub", ex);
                }
            } else {
                log.warning("Unable to connect to SAMP hub.");
            }
        }
        this.conn.setAutoconnect(10);
    }

    public void display(File file) throws SampException {
        URI uri = file.toURI();
        this.ds9Set("mosaicimage iraf", uri, 10000);
        this.ds9Set("scale scope global", null, 10000);
        this.ds9Set("zoom to fit", null, 10000);
    }

    public List<String> getDS9Version() throws SampException {
        List<Object> versions = this.ds9Get("version", 10000);
        return versions.stream().map(Object::toString).filter(item -> item.startsWith("ds9 ")).map(item -> item.substring(4)).collect(Collectors.toList());
    }

    public void ds9Set(String command, URI uri, int timeout) throws SampException {
        Message message = new Message("ds9.set");
        message.addParam("cmd", (Object)command);
        if (uri != null) {
            message.addParam("url", (Object)uri.toString());
        }
        this.conn.callAll((Map)message, new ResultHandler(){

            public void result(Client client, Response rspns) {
                if (rspns.isOK()) {
                    log.log(Level.FINE, "SAMP result: {0}: {1}", new Object[]{client, rspns});
                } else {
                    log.log(Level.WARNING, "SAMP Error: {0}", rspns.getErrInfo().getErrortxt());
                }
            }

            public void done() {
                log.log(Level.FINE, "SAMP done");
            }
        }, timeout);
    }

    public List<Object> ds9Get(String command, int timeout) throws SampException {
        final CompletableFuture future = new CompletableFuture();
        Message message = new Message("ds9.get");
        message.addParam("cmd", (Object)command);
        this.conn.callAll((Map)message, new ResultHandler(){
            List<Object> result = new ArrayList<Object>();

            public void result(Client client, Response rspns) {
                log.log(Level.FINE, "SAMP result: {0}: {1}", new Object[]{client, rspns});
                if (rspns.isOK()) {
                    this.result.add(rspns.getResult().get("value").toString());
                } else {
                    SampException x = new SampException("SAMP Error:" + rspns.getErrInfo().getErrortxt());
                    future.completeExceptionally((Throwable)x);
                }
            }

            public void done() {
                log.log(Level.FINE, "SAMP done");
                future.complete(this.result);
            }
        }, timeout);
        try {
            return (List)future.get();
        }
        catch (InterruptedException ex) {
            throw new SampException("Exception during execution of SAMP command", (Throwable)ex);
        }
        catch (ExecutionException ex) {
            Throwable x = ex.getCause();
            if (x instanceof SampException) {
                throw (SampException)x;
            }
            throw new SampException("Unexpected error", x);
        }
    }

    public static void main(String[] args) throws SampException {
        SampUtils utils = new SampUtils("test", true);
        System.out.printf("version=%s\n", utils.getDS9Version());
        File file = new File("/tmp/image4829142949481327900fits");
        utils.display(file);
    }

    @Override
    public void close() throws IOException {
        this.conn.setActive(false);
    }
}

