/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.image;

import java.time.Instant;
import java.util.Date;
import nom.tam.fits.FitsDate;
import nom.tam.fits.FitsException;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

public class DateUtils {
    private DateUtils() {
    }

    private static Instant convertTemporalToInstant(Object temporalObject) {
        if (temporalObject instanceof Date) {
            Date date = (Date)temporalObject;
            return Instant.ofEpochMilli(date.getTime());
        }
        if (temporalObject instanceof Instant) {
            Instant instant = (Instant)temporalObject;
            return instant;
        }
        if (temporalObject instanceof CCSTimeStamp) {
            CCSTimeStamp ccsTimeStamp = (CCSTimeStamp)temporalObject;
            return ccsTimeStamp.getTAIInstant();
        }
        throw new IllegalArgumentException("Unsupported temporal class: " + temporalObject);
    }

    public static double convertTemporalToMJD(Object temporalObject) {
        return DateUtils.convertInstantToMJD(DateUtils.convertTemporalToInstant(temporalObject));
    }

    public static String convertTemporalToString(Object temporalObject) {
        return DateUtils.convertInstantToString(DateUtils.convertTemporalToInstant(temporalObject));
    }

    public static double convertInstantToMJD(Instant instant) {
        long epochSecond = instant.getEpochSecond();
        int nano = instant.getNano();
        return (double)epochSecond / 86400.0 + (double)nano / 86400.0 / 1.0E9 + 2440587.5 - 2400000.5;
    }

    static String convertInstantToString(Instant instant) {
        long epochSeconds = instant.getEpochSecond();
        int nanos = instant.getNano();
        long epochMillisRounded = epochSeconds * 1000L + Math.round((double)nanos / 1000000.0);
        return DateUtils.convertDateToString(new Date(epochMillisRounded));
    }

    static String convertDateToString(Date date) {
        return FitsDate.getFitsDateString((Date)date);
    }

    public static Date convertStringToDate(String string) throws FitsException {
        return new FitsDate(string).toDate();
    }
}

