/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.image;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import junit.framework.TestCase;
import nom.tam.fits.BasicHDU;
import nom.tam.fits.Fits;
import nom.tam.fits.FitsException;
import nom.tam.fits.HeaderCard;
import nom.tam.util.Cursor;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.lsst.ccs.utilities.ccd.CCD;
import org.lsst.ccs.utilities.ccd.CCDGeometryConstants;
import org.lsst.ccs.utilities.ccd.CCDType;
import org.lsst.ccs.utilities.ccd.SegmentGeometryConstants;
import org.lsst.ccs.utilities.image.DateUtils;
import org.lsst.ccs.utilities.image.DefaultImageSet;
import org.lsst.ccs.utilities.image.FitsCheckSumTest;
import org.lsst.ccs.utilities.image.FitsFileWriter;
import org.lsst.ccs.utilities.image.FitsHeadersSpecificationsBuilder;
import org.lsst.ccs.utilities.image.HeaderSpecification;
import org.lsst.ccs.utilities.image.ImageSet;
import org.lsst.ccs.utilities.image.MetaDataSet;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

public class FitsFileWriterTest {
    private final Random random = new Random(12345L);
    private static final List<String> primaryHeaderContent = new ArrayList<String>();
    private FitsHeadersSpecificationsBuilder headerSpecsBuilder;

    @Before
    public void prepareTests() {
        this.headerSpecsBuilder = new FitsHeadersSpecificationsBuilder();
        this.headerSpecsBuilder.addSpecFile("primary");
        this.headerSpecsBuilder.addSpecFile("extended");
        this.headerSpecsBuilder.addSpecFile("test_cond");
    }

    @Test
    public void testWrite() throws Exception {
        CCSTimeStamp obs = CCSTimeStamp.currentTime();
        File tmp = File.createTempFile("img", "fits");
        System.out.println(tmp.getAbsolutePath());
        int width = 256;
        int height = 256;
        SmallCCDType type = new SmallCCDType();
        CCD ccd = CCD.createCCD((CCDType)type);
        SmallImageSet imageSet = new SmallImageSet(ccd);
        MetaDataSet metaDataSet = new MetaDataSet();
        metaDataSet.addMetaData("", "one", (Object)"1");
        metaDataSet.addMetaData("", "two", (Object)"2");
        metaDataSet.addMetaData("", "three", (Object)"3");
        metaDataSet.addMetaData("", "one3", (Object)"13");
        metaDataSet.addMetaData("", "Some1", (Object)1234);
        metaDataSet.addMetaData("", "Some12", (Object)4453453);
        metaDataSet.addMetaData("", "Some132", (Object)34);
        metaDataSet.addMetaData("", "NDFilter", (Object)"required");
        metaDataSet.addMetaData("", "PhotodiodeSignalabc", (Object)"required");
        metaDataSet.addMetaDataMap("observation", FitsFileWriterTest.generateMetaData(obs));
        for (int i = 0; i < 1000; ++i) {
            try (FitsFileWriter writer = new FitsFileWriter(tmp, (ImageSet)imageSet, this.headerSpecsBuilder.getHeaderSpecifications(), metaDataSet);){
                writer.write(imageSet.getImageExtensionNames().get(0), this.generateFakeImageData(width, height));
            }
            FitsCheckSumTest.testCheckSum(tmp);
            try (Fits fits = new Fits(tmp);){
                fits.read();
                BasicHDU primary = fits.getHDU(0);
                Assert.assertEquals((Object)DateUtils.convertInstantToString((Instant)obs.getTAIInstant()), (Object)DateUtils.convertDateToString((Date)primary.getObservationDate()));
                Assert.assertEquals((Object)DateUtils.convertInstantToString((Instant)obs.getTAIInstant()), (Object)primary.getTrimmedString("DATE-TAI"));
                Assert.assertEquals((Object)DateUtils.convertInstantToString((Instant)obs.getUTCInstant()), (Object)primary.getTrimmedString("DATE-UTC"));
                Assert.assertEquals((double)DateUtils.convertTemporalToMJD((Object)obs), (double)((Double)primary.getHeader().findCard("MJD-OBS").getValue(Double.class, (Object)0.0)), (double)0.0);
                Assert.assertEquals((double)DateUtils.convertTemporalToMJD((Object)obs), (double)((Double)primary.getHeader().findCard("MJDTAI").getValue(Double.class, (Object)0.0)), (double)0.0);
                Assert.assertEquals((double)DateUtils.convertTemporalToMJD((Object)obs.getUTCInstant()), (double)((Double)primary.getHeader().findCard("MJDUTC").getValue(Double.class, (Object)0.0)), (double)0.0);
                Assert.assertEquals((long)3L, (long)fits.getNumberOfHDUs());
                continue;
            }
        }
    }

    private void checkPrimaryHeader(BasicHDU primaryHeader, FitsHeadersSpecificationsBuilder headerSpecsBuilder) {
        HeaderSpecification primaryHeaderSpec = (HeaderSpecification)headerSpecsBuilder.getHeaderSpecifications().get("primary");
        Cursor iter = primaryHeader.getHeader().iterator();
        while (iter.hasNext()) {
            System.out.println(((HeaderCard)iter.next()).getKey());
        }
        for (String keyword : primaryHeaderContent) {
            if (primaryHeader.getHeader().containsKey(keyword)) continue;
            System.out.println("Missing key " + keyword);
        }
    }

    @Test
    public void testWriteNaN() throws ParseException, IOException, FitsException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy.mm.dd hh:mm z");
        Date obs = sdf.parse("2015.09.15 14:11 UTC");
        Map<String, Object> metaData = FitsFileWriterTest.generateMetaData(obs);
        metaData.put("ExposureTime", Float.valueOf(Float.NaN));
        File tmp = File.createTempFile("img", "fits");
        tmp.deleteOnExit();
        int width = 256;
        int height = 256;
        SmallCCDType type = new SmallCCDType();
        CCD ccd = CCD.createCCD((CCDType)type);
        SmallImageSet imageSet = new SmallImageSet(ccd);
        MetaDataSet metaDataSet = new MetaDataSet();
        metaDataSet.addMetaDataMap("observation", metaData);
        try (FitsFileWriter writer = new FitsFileWriter(tmp, (ImageSet)imageSet, metaDataSet);){
            writer.write(imageSet.getImageExtensionNames().get(0), this.generateFakeImageData(width, height));
            TestCase.fail((String)"We should never get here");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private ByteBuffer generateFakeImageData(int imageWidth, int imageHeight) {
        int length = 4 * imageWidth * imageHeight;
        ByteBuffer buffer = ByteBuffer.allocate(length);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer data = buffer.asIntBuffer();
        while (data.hasRemaining()) {
            data.put(this.random.nextInt(65536) - 32768);
        }
        return buffer;
    }

    public static Map<String, Object> generateMetaData(Object obs) {
        HashMap<String, Object> metaData = new HashMap<String, Object>();
        metaData.put("Origin", "Galaxy9");
        metaData.put("SequenceNumber", 12);
        metaData.put("ExposureTime", 15);
        metaData.put("ObservationDate", obs);
        return metaData;
    }

    static {
        primaryHeaderContent.add("ORIGIN");
        primaryHeaderContent.add("DATE");
        primaryHeaderContent.add("DATE-OBS");
        primaryHeaderContent.add("MJD-OBS");
        primaryHeaderContent.add("IMAGETAG");
        primaryHeaderContent.add("TSTAND");
        primaryHeaderContent.add("INSTRUME");
        primaryHeaderContent.add("CONTROLL");
        primaryHeaderContent.add("CONTNUM");
        primaryHeaderContent.add("CCD_MANU");
        primaryHeaderContent.add("CCD_TYPE");
        primaryHeaderContent.add("CCD_SERN");
        primaryHeaderContent.add("LSST_NUM");
        primaryHeaderContent.add("TESTTYPE");
        primaryHeaderContent.add("IMGTYPE");
        primaryHeaderContent.add("SEQNUM");
        primaryHeaderContent.add("TEMP_SET");
        primaryHeaderContent.add("CCDTEMP");
        primaryHeaderContent.add("MONDIOD");
        primaryHeaderContent.add("MONOWL");
        primaryHeaderContent.add("FILTER");
        primaryHeaderContent.add("EXPTIME");
        primaryHeaderContent.add("SHUT_DEL");
        primaryHeaderContent.add("CTRLCFG");
        primaryHeaderContent.add("FILENAME");
        primaryHeaderContent.add("DETSIZE");
        primaryHeaderContent.add("BINX");
        primaryHeaderContent.add("BINY");
        primaryHeaderContent.add("HEADVER");
        primaryHeaderContent.add("CCDGAIN");
        primaryHeaderContent.add("CCDNOISE");
    }

    private static class SmallCCDType
    extends CCDType {
        private static final SegmentGeometryConstants SEGMENTGEOMETRY_CONSTANTS = new SegmentGeometryConstants(256, 256, 0);
        private static final CCDGeometryConstants CCD_GEOMETRY_CONSTANTS = new CCDGeometryConstants(SEGMENTGEOMETRY_CONSTANTS, 0.0, 0.0);

        public SmallCCDType() {
            super("small", "223", CCD_GEOMETRY_CONSTANTS);
        }
    }

    private class SmallImageSet
    extends DefaultImageSet {
        private final List<String> segNames;

        SmallImageSet(CCD ccd) {
            super(ccd);
            this.segNames = new ArrayList<String>();
            this.segNames.add((String)ccd.getSegmentNames().get(0));
        }

        public List<String> getImageExtensionNames() {
            return this.segNames;
        }
    }
}

