/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.ccd;

import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.lsst.ccs.utilities.ccd.CCD;
import org.lsst.ccs.utilities.ccd.CCDType;
import org.lsst.ccs.utilities.ccd.E2VCCDType;
import org.lsst.ccs.utilities.ccd.ITLCCDType;
import org.lsst.ccs.utilities.ccd.Raft;

@RunWith(value=Parameterized.class)
public class DimensionsTest {
    private final CCDType type;

    @Parameterized.Parameters(name="{0}")
    public static List<CCDType> getProductionTypes() {
        ArrayList<CCDType> res = new ArrayList<CCDType>();
        res.add((CCDType)new E2VCCDType());
        res.add((CCDType)new ITLCCDType());
        return res;
    }

    public DimensionsTest(CCDType type) {
        this.type = type;
    }

    @Test
    public void testRaftDimensions() {
        Raft r = Raft.createRaft((CCDType)this.type);
        Assert.assertEquals((long)r.getRaftGeometryConstants().getRaftx(), (long)r.getDimension().width);
        Assert.assertEquals((long)r.getRaftGeometryConstants().getRafty(), (long)r.getDimension().height);
    }

    @Test
    public void testCCDDimensions() {
        CCD c = CCD.createCCD((CCDType)this.type);
        Assert.assertEquals((long)c.getType().getCCDGeometryConstants().getPhysicalAreaParallelSize(), (long)c.getDimension().width);
        Assert.assertEquals((long)c.getType().getCCDGeometryConstants().getPhysicalAreaSerialSize(), (long)c.getDimension().height);
    }
}

