/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.ccd;

import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.utilities.ccd.CCD;
import org.lsst.ccs.utilities.ccd.CornerRaft;
import org.lsst.ccs.utilities.ccd.E2VCCDType;
import org.lsst.ccs.utilities.ccd.FocalPlane;
import org.lsst.ccs.utilities.ccd.ITLCCDType;
import org.lsst.ccs.utilities.ccd.Raft;
import org.lsst.ccs.utilities.ccd.Reb;

public class CreationFromDescriptionTest {
    @Test
    public void testFocalPlaneFull() {
        FocalPlane fp = FocalPlane.createFocalPlane();
        Assert.assertNotNull((Object)fp);
        Assert.assertEquals((long)25L, (long)fp.getChildrenList().size());
        int countCornerRafts = 0;
        for (Raft r : fp.getChildrenList()) {
            if (FocalPlane.isCornerRaft((String)r.getName())) {
                Assert.assertTrue((boolean)(r instanceof CornerRaft));
                ++countCornerRafts;
                continue;
            }
            Assert.assertTrue((!(r instanceof CornerRaft) ? 1 : 0) != 0);
        }
        Assert.assertEquals((long)4L, (long)countCornerRafts);
        Reb reb = fp.getReb("R12/Reb0");
        Assert.assertNotNull((Object)reb);
        reb = fp.getReb("R00/RebW");
        Assert.assertNotNull((Object)reb);
        try {
            reb = fp.getReb("R04/Reb0");
            Assert.assertTrue((boolean)false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        reb = fp.getReb("R40/RebG");
        Assert.assertNotNull((Object)reb);
        try {
            reb = fp.getReb("R22/RebG");
            Assert.assertTrue((boolean)false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testFocalPlaneSimple() {
        ArrayList<String> raftsToCreate = new ArrayList<String>();
        raftsToCreate.add("R10");
        raftsToCreate.add("R41");
        raftsToCreate.add("R33");
        raftsToCreate.add("R24");
        raftsToCreate.add("R44");
        Object focalPlaneDescription = "[";
        int count = 1;
        for (String r : raftsToCreate) {
            focalPlaneDescription = (String)focalPlaneDescription + r;
            if (++count > raftsToCreate.size()) continue;
            focalPlaneDescription = (String)focalPlaneDescription + ",";
        }
        focalPlaneDescription = (String)focalPlaneDescription + "]";
        FocalPlane fp = FocalPlane.createFocalPlane((String)focalPlaneDescription);
        Assert.assertNotNull((Object)fp);
        Assert.assertEquals((long)fp.getChildrenList().size(), (long)raftsToCreate.size());
        int countCornerRafts = 0;
        for (Raft r : fp.getChildrenList()) {
            if (FocalPlane.isCornerRaft((String)r.getName())) {
                Assert.assertTrue((boolean)(r instanceof CornerRaft));
                ++countCornerRafts;
            } else {
                Assert.assertTrue((!(r instanceof CornerRaft) ? 1 : 0) != 0);
            }
            Assert.assertTrue((boolean)raftsToCreate.remove(r.getName()));
        }
        Assert.assertEquals((long)1L, (long)countCornerRafts);
        Assert.assertTrue((boolean)raftsToCreate.isEmpty());
    }

    @Test
    public void testFocalPlaneWithDifferentRafts() {
        String focalPlaneDescription = "[R22:[ccdType:itl],R34, R04, R44]";
        FocalPlane fp = FocalPlane.createFocalPlane((String)focalPlaneDescription);
        List rafts = fp.getChildrenList();
        Assert.assertTrue((rafts.size() == 4 ? 1 : 0) != 0);
        int countCornerRafts = 0;
        for (Raft r : rafts) {
            if (!FocalPlane.isCornerRaft((String)r.getName())) {
                if (r.getName().equals("R22")) {
                    Assert.assertTrue((boolean)(r.getType() instanceof ITLCCDType));
                } else {
                    Assert.assertTrue((boolean)(r.getType() instanceof E2VCCDType));
                }
                Assert.assertEquals((long)9L, (long)r.getChildrenList().size());
                continue;
            }
            ++countCornerRafts;
            Assert.assertTrue((r.getChildrenList().size() == 4 ? 1 : 0) != 0);
            ArrayList<String> rebNames = new ArrayList<String>();
            rebNames.add("SG0");
            rebNames.add("SG1");
            rebNames.add("SW0");
            rebNames.add("SW1");
            for (CCD ccd : r.getChildrenList()) {
                Assert.assertTrue((boolean)rebNames.remove(ccd.getName()));
            }
            Assert.assertTrue((boolean)rebNames.isEmpty());
        }
        Assert.assertEquals((long)2L, (long)countCornerRafts);
    }

    @Test
    public void testFocalPlaneForAuxTel() {
        String focalPlaneDescription = "AUXTEL";
        FocalPlane fp = FocalPlane.createFocalPlane((String)focalPlaneDescription);
        List rafts = fp.getChildrenList();
        Assert.assertEquals((long)1L, (long)rafts.size());
        int countCornerRafts = 0;
        for (Raft r : rafts) {
            if (!FocalPlane.isCornerRaft((String)r.getName())) {
                Assert.fail((String)"Only corner rafts expected");
                continue;
            }
            ++countCornerRafts;
            Assert.assertEquals((long)1L, (long)r.getChildrenList().size());
            ArrayList<String> rebNames = new ArrayList<String>();
            rebNames.add("S00");
            for (CCD ccd : r.getChildrenList()) {
                Assert.assertTrue((boolean)rebNames.remove(ccd.getName()));
            }
            Assert.assertTrue((boolean)rebNames.isEmpty());
            List rebs = r.getRebs();
            Assert.assertEquals((long)1L, (long)rebs.size());
            Assert.assertTrue((boolean)((Reb)rebs.get(0)).isAuxtelREB());
            Assert.assertEquals((long)1L, (long)((Reb)rebs.get(0)).getCCDs().size());
        }
        Assert.assertEquals((long)1L, (long)countCornerRafts);
    }
}

