/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.imagenaming;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.time.LocalDate;
import java.time.Month;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.imagenaming.Controller;
import org.lsst.ccs.imagenaming.ImageName;
import org.lsst.ccs.imagenaming.Source;

public class ImageNameTest {
    @Test
    public void basicTest() {
        ImageName in1 = new ImageName("MC_O_20071202_000001");
        ImageName in2 = new ImageName(Source.MainCamera, Controller.OCS, LocalDate.of(2007, Month.DECEMBER, 2), 1);
        Assert.assertEquals((Object)in1, (Object)in2);
        Assert.assertEquals((Object)in1.toString(), (Object)in2.toString());
        Assert.assertEquals((long)0L, (long)in1.compareTo(in2));
        Assert.assertEquals((Object)"20071202", (Object)in1.getDateString());
    }

    @Test
    public void indexTest() {
        ImageName in1 = new ImageName("GC123_O_20071202_000001");
        ImageName in2 = new ImageName(Source.GenericCamera, 123, Controller.OCS, LocalDate.of(2007, Month.DECEMBER, 2), 1);
        Assert.assertEquals((Object)in1, (Object)in2);
        Assert.assertEquals((Object)in1.toString(), (Object)in2.toString());
        Assert.assertEquals((long)0L, (long)in1.compareTo(in2));
        Assert.assertEquals((Object)"20071202", (Object)in1.getDateString());
    }

    @Test
    public void serializationTest() throws IOException, ClassNotFoundException {
        ImageName in1 = new ImageName("MC_O_20071202_000001");
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try (ObjectOutputStream out = new ObjectOutputStream(bos);){
            out.writeObject(in1);
        }
        try (ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(bos.toByteArray()));){
            ImageName in2 = (ImageName)in.readObject();
            Assert.assertEquals((Object)in1, (Object)in2);
            Assert.assertEquals((Object)in1.toString(), (Object)in2.toString());
            Assert.assertEquals((long)0L, (long)in1.compareTo(in2));
        }
    }

    @Test
    public void failTest() {
        try {
            ImageName in = new ImageName("XX_O_20071202_000001");
            Assert.fail((String)"Should not get here");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void failTest2() {
        try {
            ImageName in = new ImageName("MC_X_20071202_000001");
            Assert.fail((String)"Should not get here");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void failTest3() {
        try {
            ImageName in = new ImageName("MC_O_20071302_000001");
            Assert.fail((String)"Should not get here");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void failTest4() {
        try {
            ImageName in = new ImageName("MC_O_20071202_000000");
            Assert.fail((String)"Should not get here");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void failTest5() {
        try {
            ImageName in = new ImageName("MCO_20071202_000000");
            Assert.fail((String)"Should not get here");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void failTest6() {
        try {
            ImageName in = new ImageName(null);
            Assert.fail((String)"Should not get here");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void imageOrderTest() {
        List<String> imageNameStrings = List.of("MC_O_20071202_000001", "MC_C_20071202_000002", "MC_O_20071202_000003");
        List imageNames = imageNameStrings.stream().map(ins -> new ImageName(ins)).collect(Collectors.toCollection(ArrayList::new));
        Collections.sort(imageNames);
        Assert.assertEquals((Object)imageNameStrings.toString(), (Object)imageNames.toString());
    }
}

