package org.lsst.ccs.utilities.readout;

import org.lsst.ccs.utilities.ccd.CCDType;

/**
 * Builds a set of readout parameters,
 *
 * @author tonyj
 */
public class ReadOutParametersBuilder {

    private int[] registers;
    private CCDType ccdType;
    private ReadOutRegisterMap registerMap;

    private ReadOutParametersBuilder() {
    }

    public static ReadOutParametersBuilder create() {
        return new ReadOutParametersBuilder();
    }

    public ReadOutParametersBuilder readoutParameterNames(String[] readoutParameterNames) {
        this.registerMap = new ReadOutRegisterMap(readoutParameterNames);
        return this;
    }

    public ReadOutParametersBuilder readoutParameterValues(int[] registers) {
        this.registers = registers;
        return this;
    }

    /**
     * Explicitly set the ccdType, unnecessary if it can be obtained from the
     * readoutParameters
     *
     * @param ccdType
     * @return This object to support method chaining
     */
    public ReadOutParametersBuilder ccdType(CCDType ccdType) {
        this.ccdType = ccdType;
        return this;
    }

    public ReadOutParameters build() {
        ReadOutParameters readoutParameters;
        if (registers == null && registerMap == null) {
            readoutParameters = new ReadOutParametersOld(ccdType);
        } else if (ccdType == null) {
            return new ReadOutParametersNew(registers, registerMap);
        } else if (registers == null || registerMap == null || registers.length != registerMap.size()) {
            throw new RuntimeException("Inconsistent registers and registerMap");
        } else if (registerMap.contains("OpFlags")) {
            readoutParameters = new ReadOutParametersNew(registers, registerMap);
        } else {
            readoutParameters = new ReadOutParametersOld(ccdType, registers, registerMap);
        }
        readoutParameters.validate();
        return readoutParameters;
    }
}
