package org.lsst.ccs.utilities.location;

/**
 * An Enumeration used to define the Camera.
 *
 * @author The LSST CCS Team
 */
public enum Camera {

    LSSTCAM, AUXTEL, COMCAM, TS8;

    /**
     * Try to guess the camera based on the DAQ partition name
     *
     * @param partition The DAQ partition name
     * @return The corresponding camera
     * @throws RuntimeException if the partition is not recognized
     */
    @Deprecated
    public static Camera forDaqPartition(String partition) {
        switch (partition) {
            case "lsstcam", "camera", "guider", "bts" -> {
                return LSSTCAM;
            }
            case "comcam" -> {
                return COMCAM;
            }
            case "lat" -> {
                return AUXTEL;
            }
            case "ts8" -> {
                return TS8;
            }
            default -> throw new RuntimeException("Unrecognized DAQ partition: " + partition);
        }
    }
    /**
     * Try to guess the camera based on the DAQ partition and platform name
     *
     * @param partition The DAQ partition name
     * @param platform The DAQ platform name
     * @return The corresponding camera
     * @throws RuntimeException if the partition or platform is not recognized
     */
    public static Camera forDAQPartitionAndPlatform(String partition, String platform) {
        switch (partition) {
            case "lsstcam", "camera", "guider", "bts" -> {
                return LSSTCAM;
            }
            case "comcam" -> {
                return COMCAM;
            }
            case "lat" -> {
                return AUXTEL;
            }
            case "ts8" -> {
                return TS8;
            }
            case "emu" -> {
                switch (platform) {
                    case "comcam" -> {
                        return COMCAM;
                    }
                    case "auxtel" -> {
                        return AUXTEL;
                    }
                    default ->
                        throw new RuntimeException("Unrecognized DAQ platform: " + platform);
                }
            }
            default ->
                throw new RuntimeException("Unrecognized DAQ partition: " + partition);
        }
    }
}
