/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.utilities.ccd;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.lsst.ccs.utilities.readout.WcsCoordinatesFitsHeaderMetadataProvider;

/**
 *
 * @author turri
 */
public class VisualizeFocalPlane {

    public static class SegmentRectangle extends JPanel {

        private final CCDType type;
        private final boolean isCorner;
        private final Color c;
        private final Raft r;
        private final CCD ccd;
        private final int x0, y0, deltax, deltay;

        SegmentRectangle(Segment seg, Map<String, Object> map) {
            ccd = (CCD) (seg.getParent());
            r = (Raft) (ccd.getParent());

            int crval1f = Double.valueOf((String)map.get("CRVAL1F")).intValue();
            int crval2f = Double.valueOf((String)map.get("CRVAL2F")).intValue();

            int d12 = Double.valueOf((String)map.get("PC1_2F")).intValue();
            int d21 = Double.valueOf((String)map.get("PC2_1F")).intValue();
            int d11 = Double.valueOf((String)map.get("PC1_1F")).intValue();
            int d22 = Double.valueOf((String)map.get("PC2_2F")).intValue();

            String datasec = (String) map.get("DATASEC");
            String xRange = datasec.replace("[", "").replace("]", "").split(",")[0];
            String yRange = datasec.replace("[", "").replace("]", "").split(",")[1];

            int xmin = Integer.valueOf(xRange.split(":")[0].trim());
            int xmax = Integer.valueOf(xRange.split(":")[1].trim());
            int ymin = Integer.valueOf(yRange.split(":")[0].trim());
            int ymax = Integer.valueOf(yRange.split(":")[1].trim());

            String newDataSec = "[" + xmin + ":" + xmax + "," + ymin + ":" + ymax + "]";

            int x_first = d11 * xmin + d12 * ymin + crval1f;
            int y_first = d21 * xmin + d22 * ymin + crval2f;
            int x_last = d11 * xmax + d12 * ymax + crval1f;
            int y_last = d21 * xmax + d22 * ymax + crval2f;
            
            String fullName = r.getName() + "/" + ccd.getName() + "/" + seg.getName();

            this.isCorner = r instanceof CornerRaft;
            

//            System.out.println(fullName+" "+d11+" "+d12+" "+d21+" "+d22);
            deltax = Math.abs(x_last - x_first);
            deltay = Math.abs(y_last - y_first);

            x0 = x_last < x_first ? x_last : x_first;
            y0 = y_last < y_first ? y_last : y_first;
//            System.out.println(fullName +" ("+x+","+y+") ("+xmin+","+ymin+") ** ("+w+","+h+") ("+xmax+","+ymax+") ("+x_last+","+y_last+")");
//            System.out.println(fullName +" ("+x0+","+y0+") ("+deltax+","+deltay+") ");

            this.type = ccd.getType();
            if (!isCorner) {
                c = Color.GRAY;
            } else {
                if (type instanceof WFCCDType) {
                    c = Color.BLUE;
                } else {
                    c = Color.RED;
                }
            }
        }

        @Override
        protected void paintComponent(Graphics g) {
            g.setColor(c);
            Graphics2D g2 = (Graphics2D) g;

//            if ( !isCorner || chosenCorner.contains(r.getName()) ) {
            // draw the rectangle here
            g.drawRect(x0, y0, deltax, deltay);
//                if (isCornerSegment) {
//                    g.setColor(Color.DARK_GRAY);
//                    g.drawString(r.getName(), x0+ccd.getWidth()/16, y0+ccd.getHeight()/2);
//                }
//            }

        }

    }

    public static class FocalPlaneGeom extends JPanel {

        private final List<SegmentRectangle> segments;

        FocalPlaneGeom(List<SegmentRectangle> segments) {
            this.segments = segments;
        }

        @Override
        protected void paintComponent(Graphics g) {
            Graphics2D g2 = (Graphics2D) g;
            g.translate(700, 700);
            g2.scale(0.01, 0.01);
            g2.rotate(Math.PI);
            for (SegmentRectangle s : segments) {

                s.paintComponent(g);
            }
        }
    }

    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {

        JFrame frame = new JFrame("DrawRect");
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        frame.getContentPane().setPreferredSize(new Dimension(3800, 3800));

        FocalPlane fp = FocalPlane.createFocalPlane();
        List<SegmentRectangle> list = new ArrayList();

        for (Raft r : fp.getRafts()) {
            for (CCD ccd : r.getChildrenList()) {
                
                
                for (Segment seg : ccd.getSegments()) {
                    Map<String, Object> map = WcsCoordinatesFitsHeaderMetadataProvider.getWcsCoordinatesFor(ccd).get(ccd.getSegments().indexOf(seg));
                    SegmentRectangle segR = new SegmentRectangle(seg, map);
//                    if ( r.getName().equals("R44")  ) {

                    list.add(segR);
//                    }

                }
            }

        }
        frame.getContentPane().add(new FocalPlaneGeom(list));

        frame.pack();
        frame.setLocationByPlatform(true);
        frame.setVisible(true);

    }

}
